/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class LifeSupportTest {
    @Test
    public void testOkLifecycle() throws LifecycleException {
        LifeSupport lifeSupport = new LifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance1);
        LifecycleMock instance2 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance3);
        lifeSupport.init();
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
        lifeSupport.start();
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance3.getStatus());
        lifeSupport.stop();
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
        lifeSupport.start();
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance3.getStatus());
        lifeSupport.shutdown();
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingInit() {
        LifeSupport lifeSupport = new LifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance1);
        Exception initThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(initThrowable, null, null, null);
        lifeSupport.add((Object)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance3);
        try {
            lifeSupport.init();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)initThrowable, (Object)throwable.getCause());
        }
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.NONE, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.NONE, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingStart() {
        LifeSupport lifeSupport = new LifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance1);
        Exception startThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, startThrowable, null, null);
        lifeSupport.add((Object)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance3);
        try {
            lifeSupport.start();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)startThrowable, (Object)throwable.getCause());
        }
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingStartAndFailingStop() {
        LifeSupport lifeSupport = new LifeSupport();
        Exception stopThrowable = new Exception();
        LifecycleMock instance1 = new LifecycleMock(null, null, stopThrowable, null);
        lifeSupport.add((Object)instance1);
        Exception startThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, startThrowable, null, null);
        lifeSupport.add((Object)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance3);
        try {
            lifeSupport.start();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)stopThrowable, (Object)throwable.getCause());
            Assert.assertEquals((Object)startThrowable, (Object)throwable.getCause().getCause().getCause());
        }
        lifeSupport.dump(StringLogger.SYSTEM);
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingStop() throws LifecycleException {
        LifeSupport lifeSupport = new LifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance1);
        Exception stopThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, null, stopThrowable, null);
        lifeSupport.add((Object)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance3);
        lifeSupport.start();
        try {
            lifeSupport.stop();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)stopThrowable, (Object)throwable.getCause());
        }
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingShutdown() throws LifecycleException {
        LifeSupport lifeSupport = new LifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance1);
        Exception shutdownThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, null, null, shutdownThrowable);
        lifeSupport.add((Object)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance3);
        lifeSupport.start();
        try {
            lifeSupport.shutdown();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)shutdownThrowable, (Object)throwable.getCause());
        }
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance3.getStatus());
    }

    @Test
    public void testRestartOk() throws LifecycleException {
        LifeSupport lifeSupport = new LifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance1);
        LifecycleMock instance2 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Object)instance3);
        lifeSupport.init();
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
        lifeSupport.start();
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance3.getStatus());
        lifeSupport.stop();
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
        lifeSupport.start();
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance3.getStatus());
        lifeSupport.shutdown();
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance3.getStatus());
    }

    public class LifecycleMock
    implements Lifecycle {
        Throwable initThrowable;
        Throwable startThrowable;
        Throwable stopThrowable;
        Throwable shutdownThrowable;
        LifecycleStatus status = LifecycleStatus.NONE;

        public LifecycleMock(Throwable initThrowable, Throwable startThrowable, Throwable stopThrowable, Throwable shutdownThrowable) {
            this.initThrowable = initThrowable;
            this.startThrowable = startThrowable;
            this.stopThrowable = stopThrowable;
            this.shutdownThrowable = shutdownThrowable;
        }

        public void init() throws Throwable {
            if (this.initThrowable != null) {
                throw this.initThrowable;
            }
            this.status = LifecycleStatus.STOPPED;
        }

        public void start() throws Throwable {
            if (this.startThrowable != null) {
                throw this.startThrowable;
            }
            this.status = LifecycleStatus.STARTED;
        }

        public void stop() throws Throwable {
            this.status = LifecycleStatus.STOPPED;
            if (this.stopThrowable != null) {
                throw this.stopThrowable;
            }
        }

        public void shutdown() throws Throwable {
            this.status = LifecycleStatus.SHUTDOWN;
            if (this.shutdownThrowable != null) {
                throw this.shutdownThrowable;
            }
        }

        public LifecycleStatus getStatus() {
            return this.status;
        }
    }
}

