/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.MultipleCauseException;

public class TestMultipleCauseException {
    @Test
    public void shouldBeAbleToAddCauses() {
        Throwable cause = new Throwable();
        MultipleCauseException exception = new MultipleCauseException("Hello", cause);
        Assert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"Hello"));
        Assert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Object)cause));
        Assert.assertThat((Object)exception.getCauses(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)exception.getCauses().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(exception.getCauses().get(0), (Matcher)CoreMatchers.is((Object)cause));
    }

    @Test
    public void stackTraceShouldContainAllCauses() {
        Throwable cause1 = new Throwable("Message 1");
        MultipleCauseException exception = new MultipleCauseException("Hello", cause1);
        Throwable cause2 = new Throwable("Message 2");
        exception.addCause(cause2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        exception.printStackTrace(out);
        out.flush();
        String stackTrace = baos.toString();
        Assert.assertThat((String)"Stack trace contains exception one as cause.", (Object)stackTrace.contains("Caused by: java.lang.Throwable: Message 1"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Stack trace contains exception one as cause.", (Object)stackTrace.contains("Also caused by: java.lang.Throwable: Message 2"), (Matcher)CoreMatchers.is((Object)true));
    }
}

