/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.BufferedFileChannel;

public class TestBufferedFileChannel {
    @Test
    public void testCorrectness() throws Exception {
        File file = this.createBigTempFile(1);
        BufferedFileChannel channel = new BufferedFileChannel(new RandomAccessFile(file, "r").getChannel());
        ByteBuffer buffer = ByteBuffer.allocateDirect(15);
        int counter = 0;
        int loopCounter = 0;
        while (channel.read(buffer) != -1) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                byte value = buffer.get();
                Assert.assertEquals((long)value, (long)((byte)(counter % 10)));
                ++counter;
            }
            Assert.assertEquals((long)counter, (long)channel.position());
            int newLimit = loopCounter % buffer.capacity();
            buffer.clear().limit(newLimit == 0 ? 1 : newLimit);
            ++loopCounter;
        }
        channel.close();
        file.delete();
    }

    @Test
    public void testPositioning() throws Exception {
        File file = this.createBigTempFile(1);
        BufferedFileChannel channel = new BufferedFileChannel(new RandomAccessFile(file, "r").getChannel());
        ByteBuffer buffer = ByteBuffer.allocateDirect(15);
        channel.read(buffer);
        buffer.flip();
        int value = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((long)(value % 10), (long)buffer.get());
            ++value;
        }
        buffer.clear();
        channel.position(channel.position() + 5L);
        channel.read(buffer);
        buffer.flip();
        value = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((long)(value % 10), (long)buffer.get());
            ++value;
        }
        buffer.clear();
        channel.position(channel.size() - 13L);
        channel.read(buffer);
        buffer.flip();
        value = 7;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((long)(value % 10), (long)buffer.get());
            ++value;
        }
        channel.close();
        file.delete();
    }

    private File createBigTempFile(int mb) throws IOException {
        File file = File.createTempFile("neo4j", "temp");
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        byte[] bytes = this.newStripedBytes(1000);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        for (int i = 0; i < 1000 * mb; ++i) {
            buffer.clear();
            buffer.position(buffer.capacity());
            buffer.flip();
            channel.write(buffer);
        }
        channel.close();
        return file;
    }

    private byte[] newStripedBytes(int size) {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)(i % 10);
        }
        return result;
    }
}

