/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.Bits;

public class TestBits {
    @Test
    public void asBytes() throws Exception {
        byte numberOfBytes = 14;
        Bits bits = Bits.bits((int)numberOfBytes);
        for (byte i = 0; i < numberOfBytes; i = (byte)(i + 1)) {
            bits.put(i);
        }
        byte[] bytes = bits.asBytes();
        for (byte i = 0; i < numberOfBytes; i = (byte)(i + 1)) {
            Assert.assertEquals((long)i, (long)bytes[i]);
        }
    }

    @Test
    public void doubleAsBytes() throws Exception {
        double[] array1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        Bits bits = Bits.bits((int)(array1.length * 8));
        for (double value : array1) {
            bits.put(Double.doubleToRawLongBits(value));
        }
        String first = bits.toString();
        byte[] asBytes = bits.asBytes();
        String other = Bits.bitsFromBytes((byte[])asBytes).toString();
        Assert.assertEquals((Object)first, (Object)other);
    }

    @Test
    public void writeAndRead() throws Exception {
        Bits bits;
        for (int b = 5; b <= 8; ++b) {
            bits = Bits.bits((int)16);
            for (byte value = 0; value < 16; value = (byte)(value + 1)) {
                bits.put(value, b);
            }
            int expected = 0;
            while (bits.available()) {
                Assert.assertEquals((long)expected, (long)bits.getByte(b));
                expected = (byte)(expected + 1);
            }
        }
        for (byte value = -128; value < 127; value = (byte)(value + 1)) {
            bits = Bits.bits((int)8);
            bits.put(value);
            Assert.assertEquals((long)value, (long)bits.getByte());
        }
    }
}

