/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.ArrayMap;

public class TestArrayMap {
    @Test
    public void testArrayMap() {
        int i;
        ArrayMap map = new ArrayMap();
        Assert.assertTrue((map.get((Object)"key1") == null ? 1 : 0) != 0);
        map.put((Object)"key1", (Object)0);
        Assert.assertEquals((Object)new Integer(0), (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)new Integer(0), (Object)map.get((Object)"key1"));
        map.put((Object)"key1", (Object)1);
        Assert.assertEquals((Object)new Integer(1), (Object)map.get((Object)"key1"));
        map.put((Object)"key2", (Object)0);
        Assert.assertEquals((Object)new Integer(0), (Object)map.get((Object)"key2"));
        map.put((Object)"key2", (Object)2);
        Assert.assertEquals((Object)new Integer(2), (Object)map.get((Object)"key2"));
        Assert.assertEquals((Object)new Integer(2), (Object)map.remove((Object)"key2"));
        Assert.assertTrue((map.get((Object)"key2") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)new Integer(1), (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)new Integer(1), (Object)map.remove((Object)"key1"));
        Assert.assertTrue((map.get((Object)"key1") == null ? 1 : 0) != 0);
        map.put((Object)"key1", (Object)1);
        map.put((Object)"key2", (Object)2);
        map.put((Object)"key3", (Object)3);
        map.put((Object)"key4", (Object)4);
        map.put((Object)"key5", (Object)5);
        Assert.assertEquals((Object)new Integer(5), (Object)map.get((Object)"key5"));
        Assert.assertEquals((Object)new Integer(4), (Object)map.get((Object)"key4"));
        Assert.assertEquals((Object)new Integer(3), (Object)map.get((Object)"key3"));
        Assert.assertEquals((Object)new Integer(2), (Object)map.get((Object)"key2"));
        Assert.assertEquals((Object)new Integer(1), (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)new Integer(5), (Object)map.remove((Object)"key5"));
        Assert.assertEquals((Object)new Integer(1), (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)new Integer(4), (Object)map.get((Object)"key4"));
        Assert.assertEquals((Object)new Integer(3), (Object)map.get((Object)"key3"));
        Assert.assertEquals((Object)new Integer(2), (Object)map.get((Object)"key2"));
        Assert.assertEquals((Object)new Integer(3), (Object)map.remove((Object)"key3"));
        Assert.assertEquals((Object)new Integer(1), (Object)map.remove((Object)"key1"));
        Assert.assertEquals((Object)new Integer(2), (Object)map.remove((Object)"key2"));
        for (i = 0; i < 100; ++i) {
            map.put((Object)("key" + i), (Object)i);
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)new Integer(i), (Object)map.get((Object)("key" + i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)new Integer(i), (Object)map.remove((Object)("key" + i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((map.get((Object)("key" + i)) == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void arraymapIsClearedWhenExpandingToHashMapIfNonShrinkable() throws Exception {
        this.assertDataRepresentationSwitchesWhenAboveThreshold((ArrayMap<String, Integer>)new ArrayMap(3, false, false), false);
    }

    @Test
    public void arraymapIsClearedWhenExpandingToHashMapIfShrinkable() throws Exception {
        this.assertDataRepresentationSwitchesWhenAboveThreshold((ArrayMap<String, Integer>)new ArrayMap(3, false, true), true);
    }

    @Test
    public void arraymapIsClearedWhenExpandingToHashMapIfNonShrinkableAndSynchronized() throws Exception {
        this.assertDataRepresentationSwitchesWhenAboveThreshold((ArrayMap<String, Integer>)new ArrayMap(3, true, false), false);
    }

    @Test
    public void arraymapIsClearedWhenExpandingToHashMapIfShrinkableAndSynchronized() throws Exception {
        this.assertDataRepresentationSwitchesWhenAboveThreshold((ArrayMap<String, Integer>)new ArrayMap(3, true, true), true);
    }

    private void assertDataRepresentationSwitchesWhenAboveThreshold(ArrayMap<String, Integer> map, boolean shrinkable) throws Exception {
        Field mapThresholdField = ArrayMap.class.getDeclaredField("toMapThreshold");
        mapThresholdField.setAccessible(true);
        int arraySize = mapThresholdField.getInt(map);
        Field dataField = ArrayMap.class.getDeclaredField("data");
        dataField.setAccessible(true);
        Assert.assertTrue((boolean)(dataField.get(map) instanceof Object[]));
        for (int i = 0; i < arraySize; ++i) {
            map.put((Object)("key" + i), (Object)i);
            Assert.assertTrue((boolean)(dataField.get(map) instanceof Object[]));
        }
        map.put((Object)"next key", (Object)999);
        Map dataAsMap = (Map)dataField.get(map);
        Assert.assertEquals((long)(arraySize + 1), (long)dataAsMap.size());
        map.remove((Object)"key1");
        map.remove((Object)"key2");
        map.remove((Object)"key3");
        if (shrinkable) {
            Assert.assertTrue((boolean)(dataField.get(map) instanceof Object[]));
        } else {
            Assert.assertTrue((boolean)(dataField.get(map) instanceof Map));
        }
    }

    @Test
    public void canOverwriteThenRemoveElementAcrossDeflation() throws Exception {
        ArrayMap map = new ArrayMap(3, false, true);
        map.put((Object)"key1", (Object)1);
        map.put((Object)"key2", (Object)2);
        map.put((Object)"key3", (Object)3);
        map.put((Object)"key4", (Object)4);
        map.put((Object)"key5", (Object)5);
        map.put((Object)"key1", (Object)6);
        map.remove((Object)"key1");
        Assert.assertNull((String)"removed element still found", (Object)map.get((Object)"key1"));
        map.remove((Object)"key2");
        Assert.assertNull((String)"removed element still found", (Object)map.get((Object)"key1"));
        map.remove((Object)"key3");
        Assert.assertNull((String)"removed element still found", (Object)map.get((Object)"key1"));
        map.remove((Object)"key4");
        Assert.assertNull((String)"removed element still found", (Object)map.get((Object)"key1"));
    }

    @Test
    public void testThreadSafeSize() throws InterruptedException {
        ArrayMap map = new ArrayMap(5, true, true);
        map.put((Object)1, new Object());
        map.put((Object)2, new Object());
        map.put((Object)3, new Object());
        map.put((Object)4, new Object());
        map.put((Object)5, new Object());
        int NUM_THREADS = 100;
        CountDownLatch done = new CountDownLatch(100);
        ArrayList<WorkerThread> threads = new ArrayList<WorkerThread>(100);
        for (int i = 0; i < 100; ++i) {
            WorkerThread thread = new WorkerThread((ArrayMap<Integer, Object>)map, done);
            threads.add(thread);
            thread.start();
        }
        done.await();
        for (WorkerThread thread : threads) {
            Assert.assertTrue((String)("Synchronized ArrayMap concurrent size invoke failed: " + thread.getCause()), (boolean)thread.wasSuccessful());
        }
    }

    private static class WorkerThread
    extends Thread {
        private final ArrayMap<Integer, Object> map;
        private volatile boolean success = false;
        private volatile Throwable t = null;
        private final CountDownLatch done;

        WorkerThread(ArrayMap<Integer, Object> map, CountDownLatch done) {
            this.map = map;
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (int i = 0; i < 10000; ++i) {
                    if (this.map.size() > 5) {
                        for (int j = i; j < i + 10 && this.map.remove((Object)(j % 10)) == null; ++j) {
                        }
                    } else if (this.map.size() <= 5) {
                        this.map.put((Object)(i % 10), new Object());
                    }
                    WorkerThread.yield();
                }
                this.success = true;
            }
            catch (Throwable t) {
                this.t = t;
            }
            finally {
                this.done.countDown();
            }
        }

        boolean wasSuccessful() {
            return this.success;
        }

        Throwable getCause() {
            return this.t;
        }
    }
}

