/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestEvaluators
extends AbstractTestBase {
    @Before
    public void createGraph() {
        TestEvaluators.createGraph("a A b", "b B c", "c B d", "d C e", "e A j", "b C h", "h B i", "i C k", "a B f", "f C g");
    }

    @Test
    public void lastRelationshipTypeEvaluator() throws Exception {
        Node a = TestEvaluators.getNodeWithName("a");
        TestEvaluators.expectPaths(Traversal.traversal().evaluator(Evaluators.lastRelationshipTypeIs((Evaluation)Evaluation.INCLUDE_AND_PRUNE, (Evaluation)Evaluation.EXCLUDE_AND_CONTINUE, (RelationshipType[])new RelationshipType[]{Types.C})).traverse(a), "a,b,c,d,e", "a,f,g", "a,b,h");
        TestEvaluators.expectPaths(Traversal.traversal().evaluator(Evaluators.lastRelationshipTypeIs((Evaluation)Evaluation.INCLUDE_AND_CONTINUE, (Evaluation)Evaluation.EXCLUDE_AND_CONTINUE, (RelationshipType[])new RelationshipType[]{Types.C})).traverse(a), "a,b,c,d,e", "a,f,g", "a,b,h", "a,b,h,i,k");
    }

    @Test
    public void endNodeIs() {
        Node a = TestEvaluators.getNodeWithName("a");
        Node c = TestEvaluators.getNodeWithName("c");
        Node h = TestEvaluators.getNodeWithName("h");
        Node g = TestEvaluators.getNodeWithName("g");
        TestEvaluators.expectPaths(Traversal.description().evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{c, h, g})).traverse(a), "a,b,c", "a,b,h", "a,f,g");
        TestEvaluators.expectPaths(Traversal.description().evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{g})).traverse(a), "a,f,g");
    }

    @Test
    public void depths() throws Exception {
        Node a = TestEvaluators.getNodeWithName("a");
        TestEvaluators.expectPaths(Traversal.traversal().evaluator(Evaluators.atDepth((int)1)).traverse(a), "a,b", "a,f");
        TestEvaluators.expectPaths(Traversal.traversal().evaluator(Evaluators.fromDepth((int)2)).traverse(a), "a,f,g", "a,b,h", "a,b,h,i", "a,b,h,i,k", "a,b,c", "a,b,c,d", "a,b,c,d,e", "a,b,c,d,e,j");
        TestEvaluators.expectPaths(Traversal.traversal().evaluator(Evaluators.toDepth((int)2)).traverse(a), "a", "a,b", "a,b,c", "a,b,h", "a,f", "a,f,g");
    }

    private static enum Types implements RelationshipType
    {
        A,
        B,
        C;

    }
}

