/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.SideSelectorPolicy;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.SideSelectorPolicies;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestBidirectionalTraversal
extends AbstractTestBase {
    RelationshipType to = DynamicRelationshipType.withName((String)"TO");

    @Test(expected=IllegalArgumentException.class)
    public void bothSidesMustHaveSameUniqueness() throws Exception {
        TestBidirectionalTraversal.createGraph("A TO B");
        IteratorUtil.count((Iterable)Traversal.bidirectionalTraversal().startSide(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL)).endSide(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL)).traverse(TestBidirectionalTraversal.getNodeWithName("A"), TestBidirectionalTraversal.getNodeWithName("B")));
    }

    @Test
    public void pathsForOneDirection() throws Exception {
        TestBidirectionalTraversal.createGraph("a TO b", "b TO c", "c TO d", "d TO e", "e TO f", "f TO a");
        PathExpander expander = Traversal.pathExpanderForTypes((RelationshipType)this.to, (Direction)Direction.OUTGOING);
        TestBidirectionalTraversal.expectPaths(Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).expand(expander)).traverse(TestBidirectionalTraversal.getNodeWithName("a"), TestBidirectionalTraversal.getNodeWithName("f")), "a,b,c,d,e,f");
        TestBidirectionalTraversal.expectPaths(Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_PATH).expand(expander)).traverse(TestBidirectionalTraversal.getNodeWithName("a"), TestBidirectionalTraversal.getNodeWithName("f")), "a,b,c,d,e,f", "a,b,c,d,e,f");
    }

    @Test
    public void collisionEvaluator() throws Exception {
        TestBidirectionalTraversal.createGraph("a TO b", "a TO c", "c TO b", "a TO d", "d TO e", "e TO b", "e TO f", "f TO b");
        PathExpander expander = Traversal.pathExpanderForTypes((RelationshipType)this.to, (Direction)Direction.OUTGOING);
        BidirectionalTraversalDescription traversal = Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).expand(expander));
        TestBidirectionalTraversal.expectPaths(traversal.collisionEvaluator(Evaluators.includeIfContainsAll((Node[])new Node[]{TestBidirectionalTraversal.getNodeWithName("e")})).traverse(TestBidirectionalTraversal.getNodeWithName("a"), TestBidirectionalTraversal.getNodeWithName("b")), "a,d,e,b", "a,d,e,f,b");
        TestBidirectionalTraversal.expectPaths(traversal.collisionEvaluator(Evaluators.includeIfContainsAll((Node[])new Node[]{TestBidirectionalTraversal.getNodeWithName("e"), TestBidirectionalTraversal.getNodeWithName("f")})).traverse(TestBidirectionalTraversal.getNodeWithName("a"), TestBidirectionalTraversal.getNodeWithName("b")), "a,d,e,f,b");
    }

    @Test
    public void multipleCollisionEvaluators() throws Exception {
        TestBidirectionalTraversal.createGraph("a TO b", "b TO g", "g TO c", "a TO d", "d TO e", "e TO c", "e TO f", "f TO c");
        TestBidirectionalTraversal.expectPaths(Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH)).collisionEvaluator(Evaluators.atDepth((int)3)).collisionEvaluator(Evaluators.includeIfContainsAll((Node[])new Node[]{TestBidirectionalTraversal.getNodeWithName("e")})).traverse(TestBidirectionalTraversal.getNodeWithName("a"), TestBidirectionalTraversal.getNodeWithName("c")), "a,d,e,c");
    }

    @Test
    public void multipleStartAndEndNodes() throws Exception {
        TestBidirectionalTraversal.createGraph("a TO d", "b TO d", "c TO d", "e TO d", "e TO f", "e TO g");
        PathExpander expander = Traversal.pathExpanderForTypes((RelationshipType)this.to);
        TraversalDescription side = Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).expand(expander);
        TestBidirectionalTraversal.expectPaths(Traversal.bidirectionalTraversal().mirroredSides(side).traverse(Arrays.asList(TestBidirectionalTraversal.getNodeWithName("a"), TestBidirectionalTraversal.getNodeWithName("b"), TestBidirectionalTraversal.getNodeWithName("c")), Arrays.asList(TestBidirectionalTraversal.getNodeWithName("f"), TestBidirectionalTraversal.getNodeWithName("g"))), "a,d,e,f", "a,d,e,g", "b,d,e,f", "b,d,e,g", "c,d,e,f", "c,d,e,g");
    }

    @Test
    public void ensureCorrectPathEntitiesInShortPath() throws Exception {
        TestBidirectionalTraversal.createGraph("a TO b");
        Node a = TestBidirectionalTraversal.getNodeWithName("a");
        Node b = TestBidirectionalTraversal.getNodeWithName("b");
        Relationship r = a.getSingleRelationship(this.to, Direction.OUTGOING);
        Path path = (Path)IteratorUtil.single((Iterable)Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().relationships(this.to, Direction.OUTGOING).uniqueness((UniquenessFactory)Uniqueness.NODE_PATH)).collisionEvaluator(Evaluators.atDepth((int)1)).sideSelector((SideSelectorPolicy)SideSelectorPolicies.LEVEL, 1).traverse(a, b));
        TestBidirectionalTraversal.assertContainsInOrder(path.nodes(), a, b);
        TestBidirectionalTraversal.assertContainsInOrder(path.reverseNodes(), b, a);
        TestBidirectionalTraversal.assertContainsInOrder(path.relationships(), r);
        TestBidirectionalTraversal.assertContainsInOrder(path.reverseRelationships(), r);
        TestBidirectionalTraversal.assertContainsInOrder(path, new PropertyContainer[]{a, r, b});
        Assert.assertEquals((Object)a, (Object)path.startNode());
        Assert.assertEquals((Object)b, (Object)path.endNode());
        Assert.assertEquals((Object)r, (Object)path.lastRelationship());
    }
}

