/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class DepthOneTraversalTest
extends AbstractTestBase {
    @Before
    public void createTheGraph() {
        DepthOneTraversalTest.createGraph("0 ROOT 1", "1 KNOWS 2", "2 KNOWS 3", "2 KNOWS 4", "4 KNOWS 5", "5 KNOWS 6", "3 KNOWS 1");
    }

    private void shouldGetBothNodesOnDepthOne(TraversalDescription description) {
        description = description.evaluator(Evaluators.atDepth((int)1));
        DepthOneTraversalTest.expectNodes(description.traverse(DepthOneTraversalTest.getNodeWithName("3")), "1", "2");
    }

    @Test
    public void shouldGetBothNodesOnDepthOneForDepthFirst() {
        this.shouldGetBothNodesOnDepthOne(Traversal.traversal().depthFirst());
    }

    @Test
    public void shouldGetBothNodesOnDepthOneForBreadthFirst() {
        this.shouldGetBothNodesOnDepthOne(Traversal.traversal().breadthFirst());
    }
}

