/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.GraphDefinition;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.tooling.GlobalGraphOperations;

public abstract class AbstractTestBase {
    private static ImpermanentGraphDatabase graphdb;
    private static Map<String, Node> nodes;
    protected static final Representation<PropertyContainer> NAME_PROPERTY_REPRESENTATION;
    protected static final Representation<Relationship> RELATIONSHIP_TYPE_REPRESENTATION;

    @Before
    public final void createDb() {
        graphdb = new ImpermanentGraphDatabase();
    }

    @After
    public final void afterSuite() {
        graphdb.shutdown();
    }

    protected static final Node node(String name) {
        return nodes.get(name);
    }

    protected static final Node getNode(long id) {
        return graphdb.getNodeById(id);
    }

    protected static final Transaction beginTx() {
        return graphdb.beginTx();
    }

    protected static void createGraph(String ... description) {
        nodes = AbstractTestBase.createGraph(GraphDescription.create(description));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Node> createGraph(GraphDefinition graph) {
        Transaction tx = graphdb.beginTx();
        try {
            Map<String, Node> result = graph.create((GraphDatabaseService)graphdb);
            tx.success();
            Map<String, Node> map = result;
            return map;
        }
        finally {
            tx.finish();
        }
    }

    protected static Node getNodeWithName(String name) {
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)graphdb).getAllNodes()) {
            String nodeName = (String)node.getProperty("name", null);
            if (nodeName == null || !nodeName.equals(name)) continue;
            return node;
        }
        return null;
    }

    protected void assertLevels(Traverser traverser, Stack<Set<String>> levels) {
        Set<String> current = levels.pop();
        for (Path position : traverser) {
            String nodeName = (String)position.endNode().getProperty("name");
            if (current.isEmpty()) {
                current = levels.pop();
            }
            Assert.assertTrue((String)("Should not contain node (" + nodeName + ") at level " + (3 - levels.size())), (boolean)current.remove(nodeName));
        }
        Assert.assertTrue((String)"Should have no more levels", (boolean)levels.isEmpty());
        Assert.assertTrue((String)"Should be empty", (boolean)current.isEmpty());
    }

    protected static <T> void expect(Iterable<? extends T> items, Representation<T> representation, String ... expected) {
        AbstractTestBase.expect(items, representation, new HashSet<String>(Arrays.asList(expected)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> void expect(Iterable<? extends T> items, Representation<T> representation, Set<String> expected) {
        Transaction tx = AbstractTestBase.beginTx();
        ArrayList<String> encounteredItems = new ArrayList<String>();
        try {
            for (T item : items) {
                String repr = representation.represent(item);
                Assert.assertTrue((String)(repr + " not expected "), (boolean)expected.remove(repr));
                encounteredItems.add(repr);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        if (!expected.isEmpty()) {
            Assert.fail((String)("The exepected elements " + expected + " were not returned. Returned were: " + encounteredItems));
        }
    }

    protected static void expectNodes(Traverser traverser, String ... nodes) {
        AbstractTestBase.expect(traverser.nodes(), NAME_PROPERTY_REPRESENTATION, nodes);
    }

    protected static void expectRelationships(Traverser traverser, String ... relationships) {
        AbstractTestBase.expect(traverser.relationships(), new RelationshipRepresentation(NAME_PROPERTY_REPRESENTATION), relationships);
    }

    protected static void expectPaths(Traverser traverser, String ... paths) {
        AbstractTestBase.expectPaths(traverser, new HashSet<String>(Arrays.asList(paths)));
    }

    protected static void expectPaths(Traverser traverser, Set<String> expected) {
        AbstractTestBase.expect(traverser, new NodePathRepresentation(NAME_PROPERTY_REPRESENTATION), expected);
    }

    protected static void expectPath(Path path, String pathAsString) {
        AbstractTestBase.expect(Arrays.asList(path), new NodePathRepresentation(NAME_PROPERTY_REPRESENTATION), pathAsString);
    }

    public static <E> void assertContains(Iterable<E> actual, E ... expected) {
        HashSet<E> expectation = new HashSet<E>(Arrays.asList(expected));
        for (E element : actual) {
            if (expectation.remove(element)) continue;
            Assert.fail((String)("unexpected element <" + element + ">"));
        }
        if (!expectation.isEmpty()) {
            Assert.fail((String)("the expected elements <" + expectation + "> were not contained"));
        }
    }

    public static <T> void assertContainsInOrder(Collection<T> collection, T ... expectedItems) {
        String collectionString = AbstractTestBase.join(", ", collection.toArray());
        Assert.assertEquals((String)collectionString, (long)expectedItems.length, (long)collection.size());
        Iterator<T> itr = collection.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Assert.assertEquals(expectedItems[i], itr.next());
            ++i;
        }
    }

    public static <T> void assertContainsInOrder(Iterable<T> collection, T ... expectedItems) {
        AbstractTestBase.assertContainsInOrder(IteratorUtil.asCollection(collection), expectedItems);
    }

    public static <T> String join(String delimiter, T ... items) {
        StringBuffer buffer = new StringBuffer();
        for (T item : items) {
            if (buffer.length() > 0) {
                buffer.append(delimiter);
            }
            buffer.append(item.toString());
        }
        return buffer.toString();
    }

    static {
        NAME_PROPERTY_REPRESENTATION = new PropertyRepresentation("name");
        RELATIONSHIP_TYPE_REPRESENTATION = new Representation<Relationship>(){

            @Override
            public String represent(Relationship item) {
                return item.getType().name();
            }
        };
    }

    protected static final class NodePathRepresentation
    implements Representation<Path> {
        private final Representation<? super Node> nodes;

        public NodePathRepresentation(Representation<? super Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public String represent(Path item) {
            StringBuilder builder = new StringBuilder();
            for (Node node : item.nodes()) {
                builder.append(builder.length() > 0 ? "," : "");
                builder.append(this.nodes.represent((Node)node));
            }
            return builder.toString();
        }
    }

    protected static final class RelationshipRepresentation
    implements Representation<Relationship> {
        private final Representation<? super Node> nodes;
        private final Representation<? super Relationship> rel;

        public RelationshipRepresentation(Representation<? super Node> nodes) {
            this(nodes, RELATIONSHIP_TYPE_REPRESENTATION);
        }

        public RelationshipRepresentation(Representation<? super Node> nodes, Representation<? super Relationship> rel) {
            this.nodes = nodes;
            this.rel = rel;
        }

        @Override
        public String represent(Relationship item) {
            return this.nodes.represent((Node)item.getStartNode()) + " " + this.rel.represent((Relationship)item) + " " + this.nodes.represent((Node)item.getEndNode());
        }
    }

    protected static final class PropertyRepresentation
    implements Representation<PropertyContainer> {
        private final String key;

        public PropertyRepresentation(String key) {
            this.key = key;
        }

        @Override
        public String represent(PropertyContainer item) {
            return (String)item.getProperty(this.key);
        }
    }

    protected static interface Representation<T> {
        public String represent(T var1);
    }
}

