/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLogFiles;

public class TestXaLogicalLogFiles {
    @Test
    public void shouldDetectLegacyLogs() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists("logical_log.active")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log.1")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log.2")).thenReturn((Object)false);
        XaLogicalLogFiles files = new XaLogicalLogFiles("logical_log", fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.LEGACY_WITHOUT_LOG_ROTATION));
    }

    @Test
    public void shouldDetectNoActiveFile() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists("logical_log.active")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log.1")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log.2")).thenReturn((Object)false);
        XaLogicalLogFiles files = new XaLogicalLogFiles("logical_log", fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.NO_ACTIVE_FILE));
    }

    @Test
    public void shouldDetectLog1Active() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists("logical_log.active")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log.1")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log.2")).thenReturn((Object)false);
        FileChannel fc = this.mockedFileChannel('1');
        Mockito.when((Object)fs.open((String)Matchers.eq((Object)"logical_log.active"), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles("logical_log", fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.LOG_1_ACTIVE));
    }

    @Test
    public void shouldDetectLog2Active() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists("logical_log.active")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log.1")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log.2")).thenReturn((Object)true);
        FileChannel fc = this.mockedFileChannel('2');
        Mockito.when((Object)fs.open((String)Matchers.eq((Object)"logical_log.active"), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles("logical_log", fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.LOG_2_ACTIVE));
    }

    @Test
    public void shouldDetectCleanShutdown() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists("logical_log.active")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log.1")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log.2")).thenReturn((Object)false);
        FileChannel fc = this.mockedFileChannel('C');
        Mockito.when((Object)fs.open((String)Matchers.eq((Object)"logical_log.active"), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles("logical_log", fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.CLEAN));
    }

    @Test
    public void shouldDetectDualLog1() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists("logical_log.active")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log.1")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log.2")).thenReturn((Object)true);
        FileChannel fc = this.mockedFileChannel('1');
        Mockito.when((Object)fs.open((String)Matchers.eq((Object)"logical_log.active"), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles("logical_log", fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.DUAL_LOGS_LOG_1_ACTIVE));
    }

    @Test
    public void shouldDetectDualLog2() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists("logical_log.active")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log.1")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log.2")).thenReturn((Object)true);
        FileChannel fc = this.mockedFileChannel('2');
        Mockito.when((Object)fs.open((String)Matchers.eq((Object)"logical_log.active"), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles("logical_log", fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.DUAL_LOGS_LOG_2_ACTIVE));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateExceptionOnUnrecognizedActiveContent() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists("logical_log.active")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log")).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists("logical_log.1")).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists("logical_log.2")).thenReturn((Object)true);
        FileChannel fc = this.mockedFileChannel(';');
        Mockito.when((Object)fs.open((String)Matchers.eq((Object)"logical_log.active"), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles("logical_log", fs);
        files.determineState();
    }

    private FileChannel mockedFileChannel(char c) throws IOException {
        return new MockedFileChannel(ByteBuffer.allocate(4).putChar(c).array());
    }

    private static class MockedFileChannel
    extends FileChannel {
        private ByteBuffer bs;

        public MockedFileChannel(byte[] bs) {
            this.bs = ByteBuffer.wrap(bs);
        }

        @Override
        public void force(boolean arg0) throws IOException {
        }

        @Override
        public FileLock lock(long arg0, long arg1, boolean arg2) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode arg0, long arg1, long arg2) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public long position() throws IOException {
            return this.bs.position();
        }

        @Override
        public FileChannel position(long arg0) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int read(ByteBuffer buffer) throws IOException {
            int start = this.bs.position();
            buffer.put(this.bs);
            return this.bs.position() - start;
        }

        @Override
        public int read(ByteBuffer buffer, long length) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public long read(ByteBuffer[] arg0, int arg1, int arg2) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public long size() throws IOException {
            return 0L;
        }

        @Override
        public long transferFrom(ReadableByteChannel arg0, long arg1, long arg2) throws IOException {
            return 0L;
        }

        @Override
        public long transferTo(long arg0, long arg1, WritableByteChannel arg2) throws IOException {
            return 0L;
        }

        @Override
        public FileChannel truncate(long arg0) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public FileLock tryLock(long arg0, long arg1, boolean arg2) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int write(ByteBuffer arg0) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int write(ByteBuffer arg0, long arg1) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public long write(ByteBuffer[] arg0, int arg1, int arg2) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        protected void implCloseChannel() throws IOException {
        }
    }
}

