/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.nio.channels.ReadableByteChannel;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.CreateSomeTransactions;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.TargetDirectory;

public class TestStandaloneLogExtractor {
    @Test
    public void testRecreateCleanDbFromStandaloneExtractor() throws Exception {
        this.run(true, 1);
    }

    @Test
    public void testRecreateUncleanDbFromStandaloneExtractor() throws Exception {
        this.run(false, 2);
    }

    private void run(boolean cleanShutdown, int nr) throws Exception {
        String sourceDir = TargetDirectory.forTest(this.getClass()).directory("source" + nr, true).getAbsolutePath();
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), CreateSomeTransactions.class.getName(), sourceDir, "" + cleanShutdown});
        new ProcessStreamHandler(process, true).waitForResult();
        GraphDatabaseAPI newDb = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabase(TargetDirectory.forTest(this.getClass()).directory("target" + nr, true).getAbsolutePath());
        NeoStoreXaDataSource ds = newDb.getXaDataSourceManager().getNeoStoreDataSource();
        LogExtractor extractor = LogExtractor.from((String)sourceDir);
        long expectedTxId = 2L;
        while (true) {
            InMemoryLogBuffer buffer = new InMemoryLogBuffer();
            long txId = extractor.extractNext((LogBuffer)buffer);
            Assert.assertEquals((long)expectedTxId++, (long)txId);
            if (expectedTxId == 9L) {
                expectedTxId = -1L;
            }
            if (txId == -1L) break;
            ds.applyCommittedTransaction(txId, (ReadableByteChannel)buffer);
        }
        DbRepresentation newRep = DbRepresentation.of((GraphDatabaseService)newDb);
        newDb.shutdown();
        Assert.assertEquals((Object)DbRepresentation.of(sourceDir), (Object)newRep);
    }
}

