/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.xaframework.BufferedReadableByteChannel;

public class TestBufferedReadableByteChannel {
    private File testFileObject;
    private RandomAccessFile testRAFile;

    @Before
    public void createFiles() throws Exception {
        File testDirectory = new File("target" + File.separator + "var");
        if (!testDirectory.exists()) {
            testDirectory.mkdirs();
        }
        this.testFileObject = new File(testDirectory, "bufferedReadableFileByteChannelTest");
        this.testRAFile = new RandomAccessFile(this.testFileObject, "rw");
    }

    @After
    public void deleteFiles() throws Exception {
        this.testRAFile.close();
        this.testFileObject.delete();
    }

    @Test
    public void testBasicCreationAndOps() throws Exception {
        FileChannel channel = this.createFromData(new int[]{1, 2, 3}, new int[]{4, 5, 6});
        Assert.assertEquals((long)12L, (long)channel.position());
        channel.position(5L);
        Assert.assertEquals((long)5L, (long)channel.position());
        channel.position(6L);
        Assert.assertEquals((long)6L, (long)channel.position());
        channel.position(0L);
        Assert.assertEquals((long)0L, (long)channel.position());
        ByteBuffer readBuffer = ByteBuffer.allocate(16);
        Assert.assertEquals((long)readBuffer.capacity(), (long)channel.read(readBuffer, 4L));
        Assert.assertEquals((long)0L, (long)channel.position());
        readBuffer.flip();
        Assert.assertEquals((long)2L, (long)readBuffer.getInt());
        Assert.assertEquals((long)3L, (long)readBuffer.getInt());
        Assert.assertEquals((long)4L, (long)readBuffer.getInt());
        Assert.assertEquals((long)5L, (long)readBuffer.getInt());
        readBuffer.flip();
        Assert.assertEquals((long)readBuffer.capacity(), (long)channel.read(readBuffer));
        Assert.assertEquals((long)readBuffer.capacity(), (long)channel.position());
        readBuffer.flip();
        Assert.assertEquals((long)1L, (long)readBuffer.getInt());
        Assert.assertEquals((long)2L, (long)readBuffer.getInt());
        Assert.assertEquals((long)3L, (long)readBuffer.getInt());
        Assert.assertEquals((long)4L, (long)readBuffer.getInt());
    }

    @Test
    public void testReadAtBoundaries() throws Exception {
        FileChannel channel = this.createFromData(new int[]{1, 2, 3}, new int[]{4, 5, 6});
        ByteBuffer readBuffer = ByteBuffer.allocate(12);
        Assert.assertEquals((long)readBuffer.capacity(), (long)channel.read(readBuffer));
        Assert.assertEquals((long)24L, (long)channel.position());
        readBuffer.flip();
        Assert.assertEquals((long)4L, (long)readBuffer.getInt());
        Assert.assertEquals((long)5L, (long)readBuffer.getInt());
        Assert.assertEquals((long)6L, (long)readBuffer.getInt());
        readBuffer.flip();
        Assert.assertEquals((long)-1L, (long)channel.read(readBuffer));
    }

    @Test
    public void testWithEmptyFile() throws Exception {
        FileChannel channel = this.createFromData(new int[0], new int[]{4, 5, 6});
        ByteBuffer readBuffer = ByteBuffer.allocate(12);
        Assert.assertEquals((long)readBuffer.capacity(), (long)channel.read(readBuffer));
        Assert.assertEquals((long)12L, (long)channel.position());
        readBuffer.flip();
        Assert.assertEquals((long)4L, (long)readBuffer.getInt());
        Assert.assertEquals((long)5L, (long)readBuffer.getInt());
        Assert.assertEquals((long)6L, (long)readBuffer.getInt());
        readBuffer.flip();
        Assert.assertEquals((long)-1L, (long)channel.read(readBuffer));
    }

    @Test
    public void testWithEmptyBuffer() throws Exception {
        FileChannel channel = this.createFromData(new int[]{1, 2, 3}, new int[0]);
        ByteBuffer readBuffer = ByteBuffer.allocate(12);
        Assert.assertEquals((long)-1L, (long)channel.read(readBuffer));
        channel.position(0L);
        Assert.assertEquals((long)readBuffer.capacity(), (long)channel.read(readBuffer));
        Assert.assertEquals((long)12L, (long)channel.position());
        readBuffer.flip();
        Assert.assertEquals((long)1L, (long)readBuffer.getInt());
        Assert.assertEquals((long)2L, (long)readBuffer.getInt());
        Assert.assertEquals((long)3L, (long)readBuffer.getInt());
    }

    private FileChannel createFromData(int[] inFile, int[] inBuffer) throws IOException {
        ByteBuffer buffer;
        FileChannel channel = this.testRAFile.getChannel();
        if (inFile.length > 0) {
            buffer = ByteBuffer.allocate(inFile.length * 4);
            for (int datum : inFile) {
                buffer.putInt(datum);
            }
            buffer.flip();
            channel.write(buffer);
            buffer.rewind();
        }
        if (inBuffer.length > 0) {
            buffer = ByteBuffer.allocate(inBuffer.length * 4);
            for (int datum : inBuffer) {
                buffer.putInt(datum);
            }
        } else {
            buffer = ByteBuffer.allocate(0);
        }
        buffer.rewind();
        channel = new BufferedReadableByteChannel(channel, buffer);
        return channel;
    }
}

