/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.BatchTransaction;

public class CreateSomeTransactions {
    public static void main(String[] args) throws IOException {
        String sourceDir = args[0];
        boolean shutdown = Boolean.parseBoolean(args[1]);
        GraphDatabaseAPI db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(sourceDir).setConfig((GraphDatabaseSetting)GraphDatabaseSettings.keep_logical_logs, "true").newGraphDatabase();
        BatchTransaction tx = BatchTransaction.beginBatchTx((GraphDatabaseService)db);
        Node node = db.createNode();
        node.setProperty("name", (Object)"First");
        Node otherNode = db.createNode();
        node.createRelationshipTo(otherNode, (RelationshipType)MyRelTypes.TEST);
        tx.restart();
        db.getXaDataSourceManager().getNeoStoreDataSource().rotateLogicalLog();
        for (int i = 0; i < 5; ++i) {
            db.createNode().setProperty("type", (Object)i);
            tx.restart();
        }
        tx.finish();
        if (shutdown) {
            db.shutdown();
        } else {
            System.exit(1);
        }
    }
}

