/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.transaction.FakeXAResource;
import org.neo4j.kernel.impl.transaction.JOTMTransactionManager;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.objectweb.jotm.Jotm;

public class UseJOTMAsTxManagerIT {
    private TransactionEventHandler<Object> failsBeforeCommitTransactionHandler = new TransactionEventHandler<Object>(){

        public Object beforeCommit(TransactionData data) throws Exception {
            throw new RuntimeException("LURING!");
        }

        public void afterCommit(TransactionData data, Object state) {
        }

        public void afterRollback(TransactionData data, Object state) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStartWithJOTM() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.tx_manager_impl.name(), "JOTM");
        ImpermanentGraphDatabase db = null;
        try {
            db = new ImpermanentGraphDatabase(config);
            Assert.assertThat((Object)db.getTxManager(), (Matcher)CoreMatchers.is(JOTMTransactionManager.class));
            Transaction tx = db.beginTx();
            Node node = null;
            try {
                node = db.createNode();
                tx.success();
            }
            finally {
                tx.finish();
            }
            Assert.assertThat((Object)db.getNodeById(node.getId()), (Matcher)CoreMatchers.is((Object)node));
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHandleFailingCommitWithExternalDataSourceGracefully() throws IllegalStateException, RollbackException, SystemException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.tx_manager_impl.name(), "JOTM");
        ImpermanentGraphDatabase db = null;
        final AtomicBoolean externalResourceWasRolledBack = new AtomicBoolean(false);
        try {
            db = new ImpermanentGraphDatabase(config);
            db.registerTransactionEventHandler(this.failsBeforeCommitTransactionHandler);
            Transaction outerTx = db.beginTx();
            FakeXAResource externalResource = new FakeXAResource("BananaStorageFacility"){

                @Override
                public void rollback(Xid xid) {
                    super.rollback(xid);
                    externalResourceWasRolledBack.set(true);
                }
            };
            db.getTxManager().getTransaction().enlistResource((XAResource)externalResource);
            try {
                db.createNode();
                Transaction innerTx = db.beginTx();
                try {
                    db.createNode();
                    innerTx.success();
                }
                finally {
                    innerTx.finish();
                }
                outerTx.success();
            }
            finally {
                outerTx.finish();
            }
            Assert.fail((String)"Transaction should have failed.");
        }
        catch (TransactionFailureException e) {
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
        Assert.assertThat((Object)externalResourceWasRolledBack.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSupportRollbacks() throws IllegalStateException, RollbackException, SystemException, NotSupportedException, SecurityException, HeuristicMixedException, HeuristicRollbackException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.tx_manager_impl.name(), "JOTM");
        ImpermanentGraphDatabase neo4j = null;
        try {
            neo4j = new ImpermanentGraphDatabase(config);
            Jotm jotm = ((JOTMTransactionManager)neo4j.getTxManager()).getJotmTxManager();
            UserTransaction userTx = jotm.getUserTransaction();
            userTx.begin();
            neo4j.createNode();
            userTx.rollback();
        }
        finally {
            if (neo4j != null) {
                neo4j.shutdown();
            }
        }
    }
}

