/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.PlaceboTm;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.DefaultLogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnectionHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class TestXaFramework
extends AbstractNeo4jTestCase {
    private TransactionManager tm;
    private XaDataSourceManager xaDsMgr;

    private String path() {
        String path = TestXaFramework.getStorePath("xafrmwrk");
        try {
            FileUtils.deleteRecursively((File)new File(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    private String resourceFile() {
        return this.file("dummy_resource");
    }

    @Before
    public void setUpFramework() {
        this.getTransaction().finish();
        this.tm = this.getEmbeddedGraphDb().getTxManager();
        this.xaDsMgr = this.getEmbeddedGraphDb().getXaDataSourceManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateXaResource() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("store_dir", "target/var");
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        this.xaDsMgr.registerDataSource((XaDataSource)new DummyXaDataSource(config, UTF8.encode((String)"DDDDDD"), "dummy_datasource", new XaFactory(new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(config)), TxIdGenerator.DEFAULT, (AbstractTransactionManager)new PlaceboTm(), (LogBufferFactory)new DefaultLogBufferFactory(), (FileSystemAbstraction)fileSystem, StringLogger.DEV_NULL, RecoveryVerifier.ALWAYS_VALID, LogPruneStrategies.NO_PRUNING)));
        XaDataSource xaDs = this.xaDsMgr.getXaDataSource("dummy_datasource");
        DummyXaConnection xaC = null;
        try {
            xaC = (DummyXaConnection)xaDs.getXaConnection();
            try {
                xaC.doStuff1();
                Assert.fail((String)"Non enlisted resource should throw exception");
            }
            catch (XAException e) {
                // empty catch block
            }
            XidImpl xid = new XidImpl(new byte[0], new byte[0]);
            xaC.getXaResource().start((Xid)xid, 0);
            try {
                xaC.doStuff1();
                xaC.doStuff2();
            }
            catch (XAException e) {
                Assert.fail((String)"Enlisted resource should not throw exception");
            }
            xaC.getXaResource().end((Xid)xid, 0x4000000);
            xaC.getXaResource().prepare((Xid)xid);
            xaC.getXaResource().commit((Xid)xid, false);
        }
        finally {
            this.xaDsMgr.unregisterDataSource("dummy_datasource");
            if (xaC != null) {
                xaC.destroy();
            }
        }
        File dir = new File(".");
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.startsWith(TestXaFramework.this.resourceFile());
            }
        });
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxIdGeneration() throws Exception {
        DummyXaDataSource xaDs1 = null;
        DummyXaConnection xaC1 = null;
        try {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("store_dir", "target/var");
            DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
            this.xaDsMgr.registerDataSource((XaDataSource)new DummyXaDataSource(config, UTF8.encode((String)"DDDDDD"), "dummy_datasource1", new XaFactory(new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(config)), TxIdGenerator.DEFAULT, (AbstractTransactionManager)new PlaceboTm(), (LogBufferFactory)new DefaultLogBufferFactory(), (FileSystemAbstraction)fileSystem, StringLogger.DEV_NULL, RecoveryVerifier.ALWAYS_VALID, LogPruneStrategies.NO_PRUNING)));
            xaDs1 = (DummyXaDataSource)this.xaDsMgr.getXaDataSource("dummy_datasource1");
            xaC1 = (DummyXaConnection)xaDs1.getXaConnection();
            this.tm.begin();
            xaC1.enlistWithTx();
            int currentTxId = xaC1.getTransactionId();
            xaC1.doStuff1();
            xaC1.delistFromTx();
            this.tm.commit();
            this.tm.begin();
            Node node = this.getGraphDb().createNode();
            xaC1.enlistWithTx();
            Assert.assertEquals((long)(++currentTxId), (long)xaC1.getTransactionId());
            xaC1.doStuff1();
            xaC1.delistFromTx();
            this.tm.commit();
            this.tm.begin();
            node = this.getGraphDb().getNodeById(node.getId());
            xaC1.enlistWithTx();
            Assert.assertEquals((long)(++currentTxId), (long)xaC1.getTransactionId());
            xaC1.doStuff2();
            xaC1.delistFromTx();
            node.delete();
            this.tm.commit();
        }
        finally {
            this.xaDsMgr.unregisterDataSource("dummy_datasource1");
            if (xaC1 != null) {
                xaC1.destroy();
            }
        }
        File dir = new File(".");
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.startsWith(TestXaFramework.this.resourceFile());
            }
        });
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }

    private class DummyXaConnection
    extends XaConnectionHelpImpl {
        private XAResource xaResource;

        public DummyXaConnection(XaResourceManager xaRm) {
            super(xaRm);
            this.xaResource = null;
            this.xaResource = new DummyXaResource(xaRm);
        }

        public XAResource getXaResource() {
            return this.xaResource;
        }

        public void doStuff1() throws XAException {
            this.validate();
            this.getTransaction().addCommand((XaCommand)new DummyCommand(1));
        }

        public void doStuff2() throws XAException {
            this.validate();
            this.getTransaction().addCommand((XaCommand)new DummyCommand(2));
        }

        public void enlistWithTx() throws Exception {
            TestXaFramework.this.tm.getTransaction().enlistResource(this.xaResource);
        }

        public void delistFromTx() throws Exception {
            TestXaFramework.this.tm.getTransaction().delistResource(this.xaResource, 0x4000000);
        }

        public int getTransactionId() throws Exception {
            return this.getTransaction().getIdentifier();
        }
    }

    private static class DummyXaResource
    extends XaResourceHelpImpl {
        DummyXaResource(XaResourceManager xaRm) {
            super(xaRm, null);
        }

        public boolean isSameRM(XAResource resource) {
            return resource instanceof DummyXaResource;
        }
    }

    public class DummyXaDataSource
    extends XaDataSource {
        private XaContainer xaContainer;

        public DummyXaDataSource(Map<String, String> map, byte[] branchId, String name, XaFactory xaFactory) throws InstantiationException {
            super(branchId, name);
            this.xaContainer = null;
            try {
                map.put("store_dir", TestXaFramework.this.path());
                this.xaContainer = xaFactory.newXaContainer((XaDataSource)this, TestXaFramework.this.resourceFile(), (XaCommandFactory)new DummyCommandFactory(), (XaTransactionFactory)new DummyTransactionFactory(), null, null);
                this.xaContainer.openLogicalLog();
            }
            catch (IOException e) {
                throw new InstantiationException("" + e);
            }
        }

        public void close() {
            this.xaContainer.close();
            File dir = new File(".");
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return fileName.startsWith(TestXaFramework.this.resourceFile());
                }
            });
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }

        public XaConnection getXaConnection() {
            return new DummyXaConnection(this.xaContainer.getResourceManager());
        }

        public long getLastCommittedTxId() {
            return 0L;
        }
    }

    private static class DummyTransactionFactory
    extends XaTransactionFactory {
        private DummyTransactionFactory() {
        }

        public XaTransaction create(int identifier) {
            return new DummyTransaction(identifier, this.getLogicalLog());
        }

        public void flushAll() {
        }

        public long getAndSetNewVersion() {
            return 0L;
        }

        public long getCurrentVersion() {
            return 0L;
        }

        public long getLastCommittedTx() {
            return 0L;
        }
    }

    private static class DummyTransaction
    extends XaTransaction {
        private List<XaCommand> commandList = new ArrayList<XaCommand>();

        public DummyTransaction(int identifier, XaLogicalLog log) {
            super(identifier, log);
            this.setCommitTxId(0L);
        }

        public void doAddCommand(XaCommand command) {
            this.commandList.add(command);
        }

        public void doPrepare() {
        }

        public void doRollback() {
        }

        public void doCommit() {
        }

        public boolean isReadOnly() {
            return false;
        }
    }

    private static class DummyCommandFactory
    extends XaCommandFactory {
        private DummyCommandFactory() {
        }

        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            buffer.clear();
            buffer.limit(4);
            if (byteChannel.read(buffer) == 4) {
                buffer.flip();
                return new DummyCommand(buffer.getInt());
            }
            return null;
        }
    }

    private static class DummyCommand
    extends XaCommand {
        private int type = -1;

        DummyCommand(int type) {
            this.type = type;
        }

        public void execute() {
        }

        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.putInt(this.type);
        }
    }
}

