/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.TransactionImpl;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.util.MultipleCauseException;

public class TestTransactionImpl {
    @Test
    public void shouldBeAbleToAccessAllExceptionsOccurringInSynchronizationsBeforeCompletion() throws IllegalStateException, RollbackException {
        TxManager mockedTxManager = (TxManager)Mockito.mock(TxManager.class);
        TransactionImpl tx = new TransactionImpl(mockedTxManager, ForceMode.forced);
        final RuntimeException firstException = new RuntimeException("Ex1");
        Synchronization meanSync1 = new Synchronization(){

            public void beforeCompletion() {
                throw firstException;
            }

            public void afterCompletion(int status) {
            }
        };
        final RuntimeException secondException = new RuntimeException("Ex1");
        Synchronization meanSync2 = new Synchronization(){

            public void beforeCompletion() {
                throw secondException;
            }

            public void afterCompletion(int status) {
            }
        };
        tx.registerSynchronization(meanSync1);
        tx.registerSynchronization(meanSync2);
        tx.doBeforeCompletion();
        Assert.assertThat((Object)tx.getRollbackCause(), (Matcher)CoreMatchers.is(MultipleCauseException.class));
        MultipleCauseException error = (MultipleCauseException)tx.getRollbackCause();
        Assert.assertThat((Object)error.getCause(), (Matcher)CoreMatchers.is((Object)firstException));
        Assert.assertThat((Object)error.getCauses().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(error.getCauses().get(0), (Matcher)CoreMatchers.is((Object)firstException));
        Assert.assertThat(error.getCauses().get(1), (Matcher)CoreMatchers.is((Object)secondException));
    }

    @Test
    public void shouldNotThrowMultipleCauseIfOnlyOneErrorOccursInBeforeCompletion() throws IllegalStateException, RollbackException {
        TxManager mockedTxManager = (TxManager)Mockito.mock(TxManager.class);
        TransactionImpl tx = new TransactionImpl(mockedTxManager, ForceMode.forced);
        final RuntimeException firstException = new RuntimeException("Ex1");
        Synchronization meanSync1 = new Synchronization(){

            public void beforeCompletion() {
                throw firstException;
            }

            public void afterCompletion(int status) {
            }
        };
        tx.registerSynchronization(meanSync1);
        tx.doBeforeCompletion();
        Assert.assertThat((Object)tx.getRollbackCause(), (Matcher)CoreMatchers.is((Object)firstException));
    }
}

