/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.util.FileUtils;

public class UpgradableDatabaseTestIT {
    @Before
    public void checkOperatingSystem() {
        Assume.assumeTrue((!System.getProperty("os.name").startsWith("Windows") ? 1 : 0) != 0);
    }

    @Test
    public void shouldAcceptTheStoresInTheSampleDatabaseAsBeingEligibleForUpgrade() throws IOException {
        URL legacyStoreResource = this.getClass().getResource("legacystore/exampledb/neostore");
        File resourceDirectory = new File(legacyStoreResource.getFile()).getParentFile();
        File workingDirectory = new File("target/" + UpgradableDatabaseTestIT.class.getSimpleName());
        FileUtils.deleteRecursively((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
        Assert.assertTrue((boolean)new UpgradableDatabase().storeFilesUpgradeable(new File(workingDirectory, "neostore")));
    }

    @Test
    public void shouldRejectStoresIfOneFileHasIncorrectVersion() throws IOException {
        URL legacyStoreResource = this.getClass().getResource("legacystore/exampledb/neostore");
        File resourceDirectory = new File(legacyStoreResource.getFile()).getParentFile();
        File workingDirectory = new File("target/" + UpgradableDatabaseTestIT.class.getSimpleName());
        FileUtils.deleteRecursively((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
        MigrationTestUtils.changeVersionNumber(new File(workingDirectory, "neostore.nodestore.db"), "v0.9.5");
        Assert.assertFalse((boolean)new UpgradableDatabase().storeFilesUpgradeable(new File(workingDirectory, "neostore")));
    }

    @Test
    public void shouldRejectStoresIfOneFileHasNoVersionAsIfNotShutDownCleanly() throws IOException {
        URL legacyStoreResource = this.getClass().getResource("legacystore/exampledb/neostore");
        File resourceDirectory = new File(legacyStoreResource.getFile()).getParentFile();
        File workingDirectory = new File("target/" + UpgradableDatabaseTestIT.class.getSimpleName());
        FileUtils.deleteRecursively((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
        MigrationTestUtils.truncateFile(new File(workingDirectory, "neostore.nodestore.db"), "StringPropertyStore v0.9.9");
        Assert.assertFalse((boolean)new UpgradableDatabase().storeFilesUpgradeable(new File(workingDirectory, "neostore")));
    }

    @Test
    public void shouldRejectStoresIfOneFileShorterThanExpectedVersionString() throws IOException {
        URL legacyStoreResource = this.getClass().getResource("legacystore/exampledb/neostore");
        File resourceDirectory = new File(legacyStoreResource.getFile()).getParentFile();
        File workingDirectory = new File("target/" + UpgradableDatabaseTestIT.class.getSimpleName());
        FileUtils.deleteRecursively((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
        int shortFileLength = 15;
        Assert.assertTrue((shortFileLength < UTF8.encode((String)"StringPropertyStore v0.9.9").length ? 1 : 0) != 0);
        MigrationTestUtils.truncateToFixedLength(new File(workingDirectory, "neostore.relationshiptypestore.db"), shortFileLength);
        Assert.assertFalse((boolean)new UpgradableDatabase().storeFilesUpgradeable(new File(workingDirectory, "neostore")));
    }
}

