/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreUpgraderTestIT {
    private StoreUpgrader newUpgrader(UpgradeConfiguration config, StoreMigrator migrator, DatabaseFiles files) {
        return new StoreUpgrader(MigrationTestUtils.defaultConfig(), StringLogger.DEV_NULL, config, new UpgradableDatabase(), migrator, files, CommonFactories.defaultIdGeneratorFactory(), CommonFactories.defaultFileSystemAbstraction());
    }

    @Test
    public void shouldUpgradeAnOldFormatStore() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldUpgradeAnOldFormatStore");
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.9.9"));
        this.newUpgrader(MigrationTestUtils.alwaysAllowed(), new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()), new DatabaseFiles()).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.A.0"));
    }

    @Test
    public void shouldLeaveACopyOfOriginalStoreFilesInBackupDirectory() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldLeaveACopyOfOriginalStoreFilesInBackupDirectory");
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        this.newUpgrader(MigrationTestUtils.alwaysAllowed(), new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()), new DatabaseFiles()).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
        MigrationTestUtils.verifyFilesHaveSameContent(MigrationTestUtils.findOldFormatStoreDirectory(), new File(workingDirectory, "upgrade_backup"));
    }

    @Test
    public void shouldHaltUpgradeIfUpgradeConfigurationVetoesTheProcess() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldHaltUpgradeIfUpgradeConfigurationVetoesTheProcess");
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        UpgradeConfiguration vetoingUpgradeConfiguration = new UpgradeConfiguration(){

            public void checkConfigurationAllowsAutomaticUpgrade() {
                throw new UpgradeNotAllowedByConfigurationException("vetoed");
            }
        };
        try {
            this.newUpgrader(vetoingUpgradeConfiguration, new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()), new DatabaseFiles()).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
            Assert.fail((String)"Should throw exception");
        }
        catch (UpgradeNotAllowedByConfigurationException upgradeNotAllowedByConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldLeaveAllFilesUntouchedIfWrongVersionNumberFound() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldLeaveAllFilesUntouchedIfWrongVersionNumberFound");
        File comparisonDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldLeaveAllFilesUntouchedIfWrongVersionNumberFound-comparison");
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        MigrationTestUtils.changeVersionNumber(new File(workingDirectory, "neostore.nodestore.db"), "v0.9.5");
        FileUtils.deleteRecursively((File)comparisonDirectory);
        FileUtils.copyRecursively((File)workingDirectory, (File)comparisonDirectory);
        try {
            this.newUpgrader(MigrationTestUtils.alwaysAllowed(), new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()), new DatabaseFiles()).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
            Assert.fail((String)"Should throw exception");
        }
        catch (StoreUpgrader.UnableToUpgradeException unableToUpgradeException) {
            // empty catch block
        }
        MigrationTestUtils.verifyFilesHaveSameContent(comparisonDirectory, workingDirectory);
    }

    @Test
    public void shouldRefuseToUpgradeIfAnyOfTheStoresWeNotShutDownCleanly() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldRefuseToUpgradeIfAnyOfTheStoresWeNotShutDownCleanly");
        File comparisonDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldRefuseToUpgradeIfAnyOfTheStoresWeNotShutDownCleanly-comparison");
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        MigrationTestUtils.truncateFile(new File(workingDirectory, "neostore.propertystore.db.index.keys"), "StringPropertyStore v0.9.9");
        FileUtils.deleteRecursively((File)comparisonDirectory);
        FileUtils.copyRecursively((File)workingDirectory, (File)comparisonDirectory);
        try {
            this.newUpgrader(MigrationTestUtils.alwaysAllowed(), new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()), new DatabaseFiles()).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
            Assert.fail((String)"Should throw exception");
        }
        catch (StoreUpgrader.UnableToUpgradeException unableToUpgradeException) {
            // empty catch block
        }
        MigrationTestUtils.verifyFilesHaveSameContent(comparisonDirectory, workingDirectory);
    }

    @Test
    public void shouldRefuseToUpgradeIfAllOfTheStoresWeNotShutDownCleanly() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldRefuseToUpgradeIfAllOfTheStoresWeNotShutDownCleanly");
        File comparisonDirectory = new File("target/" + StoreUpgraderTestIT.class.getSimpleName() + "shouldRefuseToUpgradeIfAllOfTheStoresWeNotShutDownCleanly-comparison");
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        StoreUpgraderTestIT.truncateAllFiles(workingDirectory);
        FileUtils.deleteRecursively((File)comparisonDirectory);
        FileUtils.copyRecursively((File)workingDirectory, (File)comparisonDirectory);
        try {
            this.newUpgrader(MigrationTestUtils.alwaysAllowed(), new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()), new DatabaseFiles()).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
            Assert.fail((String)"Should throw exception");
        }
        catch (StoreUpgrader.UnableToUpgradeException unableToUpgradeException) {
            // empty catch block
        }
        MigrationTestUtils.verifyFilesHaveSameContent(comparisonDirectory, workingDirectory);
    }

    public static void truncateAllFiles(File workingDirectory) throws IOException {
        for (Map.Entry legacyFile : UpgradableDatabase.fileNamesToExpectedVersions.entrySet()) {
            MigrationTestUtils.truncateFile(new File(workingDirectory, (String)legacyFile.getKey()), (String)legacyFile.getValue());
        }
    }
}

