/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreUpgraderInterruptionTestIT {
    @Test
    public void shouldSucceedWithUpgradeAfterPreviousAttemptDiedDuringMigration() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderInterruptionTestIT.class.getSimpleName());
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        StoreMigrator failingStoreMigrator = new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()){

            public void migrate(LegacyStore legacyStore, NeoStore neoStore) throws IOException {
                super.migrate(legacyStore, neoStore);
                throw new RuntimeException("This upgrade is failing");
            }
        };
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.9.9"));
        try {
            this.newUpgrader(failingStoreMigrator, new DatabaseFiles()).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
            Assert.fail((String)"Should throw exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"This upgrade is failing", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.9.9"));
        this.newUpgrader(new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()), new DatabaseFiles()).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.A.0"));
    }

    private StoreUpgrader newUpgrader(StoreMigrator migrator, DatabaseFiles files) {
        return new StoreUpgrader(MigrationTestUtils.defaultConfig(), StringLogger.DEV_NULL, MigrationTestUtils.alwaysAllowed(), new UpgradableDatabase(), migrator, files, CommonFactories.defaultIdGeneratorFactory(), CommonFactories.defaultFileSystemAbstraction());
    }

    @Test
    public void shouldFailOnSecondAttemptIfPreviousAttemptMadeABackupToAvoidDamagingBackup() throws IOException {
        File workingDirectory = new File("target/" + StoreUpgraderInterruptionTestIT.class.getSimpleName());
        MigrationTestUtils.prepareSampleLegacyDatabase(workingDirectory);
        DatabaseFiles failsOnBackup = new DatabaseFiles(){

            public void moveToBackupDirectory(File workingDirectory, File backupDirectory) {
                backupDirectory.mkdir();
                throw new RuntimeException("Failing to backup working directory");
            }
        };
        Assert.assertTrue((boolean)MigrationTestUtils.allStoreFilesHaveVersion(workingDirectory, "v0.9.9"));
        try {
            this.newUpgrader(new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()), failsOnBackup).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
            Assert.fail((String)"Should throw exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Failing to backup working directory", (Object)e.getMessage());
        }
        try {
            this.newUpgrader(new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor()), new DatabaseFiles()).attemptUpgrade(new File(workingDirectory, "neostore").getPath());
            Assert.fail((String)"Should throw exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot proceed with upgrade because there is an existing upgrade backup in the way at "));
        }
    }
}

