/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.tooling.GlobalGraphOperations;

public class StoreMigratorTestIT {
    @Test
    public void shouldMigrate() throws IOException {
        URL legacyStoreResource = this.getClass().getResource("legacystore/exampledb/neostore");
        LegacyStore legacyStore = new LegacyStore(legacyStoreResource.getFile());
        Config config = MigrationTestUtils.defaultConfig();
        File outputDir = new File("target/outputDatabase");
        FileUtils.deleteRecursively((File)outputDir);
        Assert.assertTrue((boolean)outputDir.mkdirs());
        String storeFileName = "target/outputDatabase/neostore";
        StoreFactory factory = new StoreFactory(config, CommonFactories.defaultIdGeneratorFactory(), CommonFactories.defaultFileSystemAbstraction(), CommonFactories.defaultLastCommittedTxIdSetter(), StringLogger.DEV_NULL, CommonFactories.defaultTxHook());
        NeoStore neoStore = factory.createNeoStore(storeFileName);
        ListAccumulatorMigrationProgressMonitor monitor = new ListAccumulatorMigrationProgressMonitor();
        new StoreMigrator((MigrationProgressMonitor)monitor).migrate(legacyStore, neoStore);
        this.verifyNeoStore(neoStore);
        neoStore.close();
        Assert.assertEquals((long)100L, (long)monitor.events.size());
        Assert.assertTrue((boolean)monitor.started);
        Assert.assertTrue((boolean)monitor.finished);
        EmbeddedGraphDatabase database = new EmbeddedGraphDatabase(outputDir.getPath());
        DatabaseContentVerifier verifier = new DatabaseContentVerifier((GraphDatabaseService)database);
        verifier.verifyNodes();
        verifier.verifyRelationships();
        verifier.verifyNodeIdsReused();
        verifier.verifyRelationshipIdsReused();
        database.shutdown();
    }

    private void verifyNeoStore(NeoStore neoStore) {
        Assert.assertEquals((long)1317392957120L, (long)neoStore.getCreationTime());
        Assert.assertEquals((long)-472309512128245482L, (long)neoStore.getRandomNumber());
        Assert.assertEquals((long)0L, (long)neoStore.getVersion());
        Assert.assertEquals((long)1004L, (long)neoStore.getLastCommittedTx());
    }

    private class ListAccumulatorMigrationProgressMonitor
    implements MigrationProgressMonitor {
        private List<Integer> events = new ArrayList<Integer>();
        private boolean started = false;
        private boolean finished = false;

        private ListAccumulatorMigrationProgressMonitor() {
        }

        public void started() {
            this.started = true;
        }

        public void percentComplete(int percent) {
            this.events.add(percent);
        }

        public void finished() {
            this.finished = true;
        }
    }

    private static class DatabaseContentVerifier {
        private String longString = MigrationTestUtils.makeLongString();
        private int[] longArray = MigrationTestUtils.makeLongArray();
        private GraphDatabaseService database;

        public DatabaseContentVerifier(GraphDatabaseService database) {
            this.database = database;
        }

        private void verifyRelationships() {
            Node currentNode = this.database.getReferenceNode();
            int traversalCount = 0;
            while (currentNode.hasRelationship(Direction.OUTGOING)) {
                ++traversalCount;
                Relationship relationship = (Relationship)currentNode.getRelationships(Direction.OUTGOING).iterator().next();
                this.verifyProperties((PropertyContainer)relationship);
                currentNode = relationship.getEndNode();
            }
            Assert.assertEquals((long)500L, (long)traversalCount);
        }

        private void verifyNodes() {
            int nodeCount = 0;
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)this.database).getAllNodes()) {
                ++nodeCount;
                if (node.getId() <= 0L) continue;
                this.verifyProperties((PropertyContainer)node);
            }
            Assert.assertEquals((long)501L, (long)nodeCount);
        }

        private void verifyProperties(PropertyContainer node) {
            Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)node.getProperty(PropertyType.INT.name()));
            Assert.assertEquals((Object)this.longString, (Object)node.getProperty(PropertyType.STRING.name()));
            Assert.assertEquals((Object)true, (Object)node.getProperty(PropertyType.BOOL.name()));
            Assert.assertEquals((Object)Double.MAX_VALUE, (Object)node.getProperty(PropertyType.DOUBLE.name()));
            Assert.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)node.getProperty(PropertyType.FLOAT.name()));
            Assert.assertEquals((Object)Long.MAX_VALUE, (Object)node.getProperty(PropertyType.LONG.name()));
            Assert.assertEquals((Object)127, (Object)node.getProperty(PropertyType.BYTE.name()));
            Assert.assertEquals((Object)Character.valueOf('\uffff'), (Object)node.getProperty(PropertyType.CHAR.name()));
            Assert.assertArrayEquals((int[])this.longArray, (int[])((int[])node.getProperty(PropertyType.ARRAY.name())));
            Assert.assertEquals((Object)Short.MAX_VALUE, (Object)node.getProperty(PropertyType.SHORT.name()));
            Assert.assertEquals((Object)"short", (Object)node.getProperty(PropertyType.SHORT_STRING.name()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyNodeIdsReused() {
            try {
                this.database.getNodeById(1L);
                Assert.fail((String)"Node 2 should not exist");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            Transaction transaction = this.database.beginTx();
            try {
                Node newNode = this.database.createNode();
                Assert.assertEquals((long)1L, (long)newNode.getId());
                transaction.success();
            }
            finally {
                transaction.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyRelationshipIdsReused() {
            Transaction transaction = this.database.beginTx();
            try {
                Node node1 = this.database.createNode();
                Node node2 = this.database.createNode();
                Relationship relationship1 = node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"REUSE"));
                Assert.assertEquals((long)0L, (long)relationship1.getId());
                transaction.success();
            }
            finally {
                transaction.finish();
            }
        }
    }
}

