/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.ProduceUncleanStore;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.test.TargetDirectory;

public class TestStoreAccess {
    @Rule
    public TargetDirectory.TestDirectory testdir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void openingThroughStoreAccessShouldNotTriggerRecovery() throws Exception {
        ProduceUncleanStore.atPath(this.testdir.directory());
        Assert.assertTrue((String)"Store should be unclean", (boolean)this.isUnclean(this.testdir.directory()));
        File messages = new File(this.testdir.directory(), "messages.log");
        long eof = messages.length();
        new StoreAccess(this.testdir.directory().getAbsolutePath()).close();
        String data = this.readFrom(messages, eof);
        Assert.assertFalse((String)"should not have started GraphDatabase", (boolean)data.contains("STARTUP"));
        Assert.assertTrue((String)"Store should be unclean", (boolean)this.isUnclean(this.testdir.directory()));
    }

    private boolean isUnclean(File directory) throws IOException {
        char chr = this.activeLog(directory);
        return chr == '1' || chr == '2';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFrom(File file, long start) throws IOException {
        RandomAccessFile input = new RandomAccessFile(file, "r");
        try {
            byte[] data = new byte[(int)(input.length() - start)];
            input.seek(start);
            Assert.assertEquals((long)data.length, (long)input.read(data));
            String string = new String(data);
            return string;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char activeLog(File directory) throws IOException {
        RandomAccessFile file = new RandomAccessFile(new File(directory, "nioneo_logical.log.active"), "r");
        try {
            char c = file.readChar();
            return c;
        }
        finally {
            file.close();
        }
    }
}

