/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.util.StringLogger;

public class TestStore {
    public static IdGeneratorFactory ID_GENERATOR_FACTORY = new DefaultIdGeneratorFactory();
    public static FileSystemAbstraction FILE_SYSTEM = new DefaultFileSystemAbstraction();

    private String path() {
        String path = AbstractNeo4jTestCase.getStorePath("teststore");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    private String storeFile() {
        return this.file("testStore.db");
    }

    private String storeIdFile() {
        return this.file("testStore.db.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStore() throws IOException {
        try {
            try {
                Store.createStore(null);
                Assert.fail((String)"Null fileName should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            Store store = Store.createStore(this.storeFile());
            try {
                Store.createStore(this.storeFile());
                Assert.fail((String)"Creating existing store should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private void deleteBothFiles() {
        File file = new File(this.storeFile());
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.storeIdFile())).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyStore() throws IOException {
        try {
            Store.createStore(this.storeFile()).close();
            FileChannel fileChannel = new RandomAccessFile(this.storeFile(), "rw").getChannel();
            fileChannel.truncate(fileChannel.size() - 2L);
            fileChannel.close();
            Store store = new Store(this.storeFile());
            store.makeStoreOk();
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() throws IOException {
        try {
            Store store = Store.createStore(this.storeFile());
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private static class Store
    extends AbstractStore {
        public static final String TYPE_DESCRIPTOR = "TestVersion";
        private static final int RECORD_SIZE = 1;

        public Store(String fileName) throws IOException {
            super(fileName, new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(MapUtil.stringMap((String[])new String[]{"store_dir", "target/var/teststore"}))), IdType.NODE, ID_GENERATOR_FACTORY, FILE_SYSTEM, StringLogger.DEV_NULL);
        }

        public int getRecordSize() {
            return 1;
        }

        public String getTypeDescriptor() {
            return TYPE_DESCRIPTOR;
        }

        public static Store createStore(String fileName) throws IOException {
            new StoreFactory(new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(Collections.emptyMap())), ID_GENERATOR_FACTORY, FILE_SYSTEM, null, StringLogger.DEV_NULL, null).createEmptyStore(fileName, Store.buildTypeDescriptorAndVersion((String)TYPE_DESCRIPTOR));
            return new Store(fileName);
        }

        protected void rebuildIdGenerator() {
        }

        public List<WindowPoolStats> getAllWindowPoolStats() {
            return null;
        }
    }
}

