/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;

@AbstractNeo4jTestCase.RequiresPersistentGraphDatabase(value=false)
public class TestPropertyBlocks
extends AbstractNeo4jTestCase {
    @Override
    protected boolean restartGraphDbBetweenTests() {
        return true;
    }

    @Test
    public void simpleAddIntegers() {
        int i;
        long inUseBefore = this.propertyRecordsInUse();
        Node node = this.getGraphDb().createNode();
        for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
            node.setProperty("prop" + i, (Object)i);
            Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
            Assert.assertEquals((Object)i, (Object)node.getProperty("prop" + i));
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
            Assert.assertEquals((Object)i, (Object)node.getProperty("prop" + i));
        }
        for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
            Assert.assertEquals((Object)i, (Object)node.removeProperty("prop" + i));
            Assert.assertFalse((boolean)node.hasProperty("prop" + i));
        }
        this.commit();
        Assert.assertEquals((long)inUseBefore, (long)this.propertyRecordsInUse());
    }

    @Test
    public void simpleAddDoubles() {
        int i;
        long inUseBefore = this.propertyRecordsInUse();
        Node node = this.getGraphDb().createNode();
        for (i = 0; i < PropertyType.getPayloadSizeLongs() / 2; ++i) {
            node.setProperty("prop" + i, (Object)((double)i * -1.0));
            Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
            Assert.assertEquals((Object)((double)i * -1.0), (Object)node.getProperty("prop" + i));
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        for (i = 0; i < PropertyType.getPayloadSizeLongs() / 2; ++i) {
            Assert.assertEquals((Object)((double)i * -1.0), (Object)node.getProperty("prop" + i));
        }
        for (i = 0; i < PropertyType.getPayloadSizeLongs() / 2; ++i) {
            Assert.assertEquals((Object)((double)i * -1.0), (Object)node.removeProperty("prop" + i));
            Assert.assertFalse((boolean)node.hasProperty("prop" + i));
        }
        this.commit();
        Assert.assertEquals((long)inUseBefore, (long)this.propertyRecordsInUse());
    }

    @Test
    public void deleteEverythingInMiddleRecord() {
        int i;
        long inUseBefore = this.propertyRecordsInUse();
        Node node = this.getGraphDb().createNode();
        for (i = 0; i < 3 * PropertyType.getPayloadSizeLongs(); ++i) {
            node.setProperty("shortString" + i, (Object)String.valueOf(i));
        }
        Assert.assertEquals((long)(inUseBefore + 3L), (long)this.propertyRecordsInUse());
        this.newTransaction();
        this.clearCache();
        for (i = PropertyType.getPayloadSizeLongs(); i < 2 * PropertyType.getPayloadSizeLongs(); ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)node.removeProperty("shortString" + i));
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 2L), (long)this.propertyRecordsInUse());
        for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)node.removeProperty("shortString" + i));
        }
        for (i = PropertyType.getPayloadSizeLongs(); i < 2 * PropertyType.getPayloadSizeLongs(); ++i) {
            Assert.assertFalse((boolean)node.hasProperty("shortString" + i));
        }
        for (i = 2 * PropertyType.getPayloadSizeLongs(); i < 3 * PropertyType.getPayloadSizeLongs(); ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)node.removeProperty("shortString" + i));
        }
    }

    @Test
    public void largeTx() throws IOException {
        Node node = this.getGraphDb().createNode();
        node.setProperty("anchor", (Object)"hi");
        for (int i = 0; i < 255; ++i) {
            node.setProperty("foo", (Object)1);
            node.removeProperty("foo");
        }
        this.commit();
    }

    @Test
    public void deleteAndAddToFullPropertyRecord() {
        int i;
        Node node = this.getGraphDb().createNode();
        for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
            node.setProperty("prop" + i, (Object)i);
        }
        this.newTransaction();
        this.clearCache();
        for (i = 0; i < PropertyType.getPayloadSizeLongs() - 1; ++i) {
            Assert.assertEquals((Object)i, (Object)node.removeProperty("prop" + i));
        }
        node.setProperty("profit", (Object)5);
        this.newTransaction();
        this.clearCache();
        int remainingProperty = PropertyType.getPayloadSizeLongs() - 1;
        Assert.assertEquals((Object)remainingProperty, (Object)node.getProperty("prop" + remainingProperty));
        Assert.assertEquals((Object)5, (Object)node.getProperty("profit"));
    }

    @Test
    public void checkPacking() {
        long inUseBefore = this.propertyRecordsInUse();
        Node node = this.getGraphDb().createNode();
        node.setProperty("prop0", (Object)0);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        for (int i = 1; i < PropertyType.getPayloadSizeLongs(); ++i) {
            node.setProperty("prop" + i, (Object)i);
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)0, (Object)node.removeProperty("prop0"));
        node.setProperty("prop-1", (Object)-1);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)-1, (Object)node.removeProperty("prop-1"));
        Assert.assertEquals((Object)1, (Object)node.removeProperty("prop1"));
        node.setProperty("propDouble", (Object)1.0);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        node.setProperty("prop-2", (Object)-2);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    public void substituteOneLargeWithManySmallPropBlocks() {
        int i;
        Node node = this.getGraphDb().createNode();
        long inUseBefore = this.propertyRecordsInUse();
        for (i = 0; i < PropertyType.getPayloadSizeLongs() / 2; ++i) {
            node.setProperty("double" + i, (Object)((double)i * 1.0));
        }
        for (i = 0; i < PropertyType.getPayloadSizeLongs() % 2; ++i) {
            node.setProperty("int" + i, (Object)i);
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        node.removeProperty("double0");
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        node.setProperty("int-1", (Object)-1);
        node.setProperty("int-2", (Object)-2);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        node.setProperty("int-3", (Object)-3);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    public void testBlockDefragmentationWithTwoSpaces() {
        int stuffedIntegers;
        Assume.assumeTrue((PropertyType.getPayloadSizeLongs() > 2 ? 1 : 0) != 0);
        Node node = this.getGraphDb().createNode();
        long inUseBefore = this.propertyRecordsInUse();
        for (stuffedIntegers = 0; stuffedIntegers < PropertyType.getPayloadSizeLongs(); ++stuffedIntegers) {
            node.setProperty("int" + stuffedIntegers, (Object)stuffedIntegers);
        }
        Assert.assertEquals((long)stuffedIntegers, (long)PropertyType.getPayloadSizeLongs());
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        node.removeProperty("int0");
        node.removeProperty("int2");
        this.newTransaction();
        this.clearCache();
        node.setProperty("theDouble", (Object)1.0);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        Assert.assertNull((Object)node.getProperty("int0", null));
        Assert.assertEquals((Object)1, (Object)node.getProperty("int1"));
        Assert.assertNull((Object)node.getProperty("int2", null));
        for (int i = 3; i < stuffedIntegers; ++i) {
            Assert.assertEquals((Object)i, (Object)node.getProperty("int" + i));
        }
        Assert.assertEquals((Object)1.0, (Object)node.getProperty("theDouble"));
    }

    @Test
    public void checkDeletesRemoveRecordsWhenProper() {
        int i;
        int stuffedBooleans;
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        for (stuffedBooleans = 0; stuffedBooleans < PropertyType.getPayloadSizeLongs(); ++stuffedBooleans) {
            node.setProperty("boolean" + stuffedBooleans, (Object)(stuffedBooleans % 2 == 0 ? 1 : 0));
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        node.setProperty("theExraOne", (Object)true);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        for (i = 0; i < stuffedBooleans; ++i) {
            Assert.assertEquals((Object)(i % 2 == 0 ? 1 : 0), (Object)node.removeProperty("boolean" + i));
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        for (i = 0; i < stuffedBooleans; ++i) {
            Assert.assertFalse((boolean)node.hasProperty("boolean" + i));
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)node.getProperty("theExraOne"));
    }

    @Test
    public void testMessWithMiddleRecordDeletes() {
        int i;
        int stuffedShortStrings;
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        for (stuffedShortStrings = 0; stuffedShortStrings < 3 * PropertyType.getPayloadSizeLongs(); ++stuffedShortStrings) {
            node.setProperty("shortString" + stuffedShortStrings, (Object)String.valueOf(stuffedShortStrings));
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
        int secondBlockInSecondRecord = PropertyType.getPayloadSizeLongs() + 1;
        int thirdBlockInSecondRecord = PropertyType.getPayloadSizeLongs() + 2;
        Assert.assertEquals((Object)String.valueOf(secondBlockInSecondRecord), (Object)node.removeProperty("shortString" + secondBlockInSecondRecord));
        Assert.assertEquals((Object)String.valueOf(thirdBlockInSecondRecord), (Object)node.removeProperty("shortString" + thirdBlockInSecondRecord));
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
        for (int i2 = 0; i2 < stuffedShortStrings; ++i2) {
            if (i2 == secondBlockInSecondRecord) {
                Assert.assertFalse((boolean)node.hasProperty("shortString" + i2));
                continue;
            }
            if (i2 == thirdBlockInSecondRecord) {
                Assert.assertFalse((boolean)node.hasProperty("shortString" + i2));
                continue;
            }
            Assert.assertEquals((Object)String.valueOf(i2), (Object)node.getProperty("shortString" + i2));
        }
        int deletedProps = 0;
        for (i = PropertyType.getPayloadSizeLongs(); i < PropertyType.getPayloadSizeLongs() * 2; ++i) {
            if (!node.hasProperty("shortString" + i)) continue;
            ++deletedProps;
            node.removeProperty("shortString" + i);
        }
        Assert.assertEquals((long)(PropertyType.getPayloadSizeLongs() - 2), (long)deletedProps);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)node.removeProperty("shortString" + i));
        }
        for (i = PropertyType.getPayloadSizeLongs(); i < PropertyType.getPayloadSizeLongs() * 2; ++i) {
            Assert.assertFalse((boolean)node.hasProperty("shortString" + i));
        }
        for (i = PropertyType.getPayloadSizeLongs() * 2; i < PropertyType.getPayloadSizeLongs() * 3; ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)node.removeProperty("shortString" + i));
        }
    }

    @Test
    public void mixAndPackDifferentTypes() {
        int stuffedShortStrings;
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        for (stuffedShortStrings = 0; stuffedShortStrings < PropertyType.getPayloadSizeLongs(); ++stuffedShortStrings) {
            node.setProperty("shortString" + stuffedShortStrings, (Object)String.valueOf(stuffedShortStrings));
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        node.removeProperty("shortString0");
        node.removeProperty("shortString2");
        node.setProperty("theDoubleOne", (Object)-1.0);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        for (int i = 0; i < stuffedShortStrings; ++i) {
            if (i == 0) {
                Assert.assertFalse((boolean)node.hasProperty("shortString" + i));
                continue;
            }
            if (i == 2) {
                Assert.assertFalse((boolean)node.hasProperty("shortString" + i));
                continue;
            }
            Assert.assertEquals((Object)String.valueOf(i), (Object)node.getProperty("shortString" + i));
        }
        Assert.assertEquals((Object)-1.0, (Object)node.getProperty("theDoubleOne"));
    }

    @Test
    public void testAdditionsHappenAtTheFirstRecordIfFits1() {
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        node.setProperty("int1", (Object)1);
        node.setProperty("double1", (Object)1.0);
        node.setProperty("int2", (Object)2);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        node.removeProperty("double1");
        this.newTransaction();
        this.clearCache();
        node.setProperty("double2", (Object)1.0);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        node.setProperty("paddingBoolean", (Object)false);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    @Ignore(value="Assumes space to put a block is searched along the whole chain - that is not the case currently")
    public void testAdditionsHappenAtTheFirstRecordWhenFits() {
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        node.setProperty("int1", (Object)1);
        node.setProperty("double1", (Object)1.0);
        node.setProperty("int2", (Object)2);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        node.removeProperty("int1");
        this.newTransaction();
        this.clearCache();
        node.setProperty("double2", (Object)1.0);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        node.removeProperty("int2");
        this.newTransaction();
        this.clearCache();
        node.setProperty("double3", (Object)1.0);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        node.setProperty("paddingBoolean", (Object)false);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    public void testAdditionHappensInTheMiddleIfItFits() {
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        node.setProperty("int1", (Object)1);
        node.setProperty("double1", (Object)1.0);
        node.setProperty("int2", (Object)2);
        for (int stuffedShortStrings = 0; stuffedShortStrings < PropertyType.getPayloadSizeLongs(); ++stuffedShortStrings) {
            node.setProperty("shortString" + stuffedShortStrings, (Object)String.valueOf(stuffedShortStrings));
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        node.removeProperty("shortString1");
        node.setProperty("int3", (Object)3);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    public void testChangePropertyType() {
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        for (int stuffedShortStrings = 0; stuffedShortStrings < PropertyType.getPayloadSizeLongs(); ++stuffedShortStrings) {
            node.setProperty("shortString" + stuffedShortStrings, (Object)String.valueOf(stuffedShortStrings));
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        node.setProperty("shortString1", (Object)1.0);
        this.commit();
    }

    @Test
    @Ignore(value="Assumes space to put a block is searched along the whole chain - that is not the case currently")
    public void testPackingAndOverflowingValueChangeInMiddleRecord() {
        int shortArrays;
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        long valueRecordsInUseAtStart = this.dynamicArrayRecordsInUse();
        for (shortArrays = 0; shortArrays < PropertyType.getPayloadSizeLongs() - 1; ++shortArrays) {
            node.setProperty("shortArray" + shortArrays, (Object)new long[]{1L, 2L, 3L, 4L});
        }
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        node.setProperty("theDoubleThatBecomesAnArray", (Object)1.0);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        node.setProperty("theLargeArray", (Object)new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE});
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((boolean)Arrays.equals(new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE}, (long[])node.getProperty("theLargeArray")));
        Assert.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
        node.setProperty("fillerByte1", (Object)3);
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
        node.setProperty("fillerByte2", (Object)-4);
        Assert.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
        node.setProperty("theDoubleThatBecomesAnArray", (Object)new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE});
        Assert.assertEquals((long)valueRecordsInUseAtStart, (long)this.dynamicArrayRecordsInUse());
        Assert.assertEquals((long)(recordsInUseAtStart + 4L), (long)this.propertyRecordsInUse());
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((long)(recordsInUseAtStart + 4L), (long)this.propertyRecordsInUse());
        while (shortArrays-- > 0) {
            Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 3L, 4L}, (long[])node.getProperty("shortArray" + shortArrays)));
        }
        Assert.assertEquals((Object)3, (Object)node.getProperty("fillerByte1"));
        Assert.assertEquals((Object)-4, (Object)node.getProperty("fillerByte2"));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE}, (long[])node.getProperty("theLargeArray")));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, (long[])node.getProperty("theDoubleThatBecomesAnArray")));
    }

    @Test
    public void testRevertOverflowingChange() {
        Relationship rel = this.getGraphDb().createNode().createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"INVALIDATES"));
        long recordsInUseAtStart = this.propertyRecordsInUse();
        long valueRecordsInUseAtStart = this.dynamicArrayRecordsInUse();
        rel.setProperty("theByte", (Object)-8);
        rel.setProperty("theDoubleThatGrows", (Object)Math.PI);
        rel.setProperty("theInteger", (Object)-444345);
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        rel.setProperty("theDoubleThatGrows", (Object)new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE});
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((long)valueRecordsInUseAtStart, (long)this.dynamicArrayRecordsInUse());
        rel.setProperty("theDoubleThatGrows", (Object)Math.E);
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((Object)-8, (Object)rel.getProperty("theByte"));
        Assert.assertEquals((Object)-444345, (Object)rel.getProperty("theInteger"));
        Assert.assertEquals((Object)Math.E, (Object)rel.getProperty("theDoubleThatGrows"));
    }

    @Test
    public void testYoYoArrayPropertyWithinTx() {
        this.testYoyoArrayBase(false);
    }

    @Test
    public void testYoYoArrayPropertyOverTxs() {
        this.testYoyoArrayBase(true);
    }

    private void testYoyoArrayBase(boolean withNewTx) {
        Relationship rel = this.getGraphDb().createNode().createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"LOCKS"));
        long recordsInUseAtStart = this.propertyRecordsInUse();
        long valueRecordsInUseAtStart = this.dynamicArrayRecordsInUse();
        ArrayList<Long> theYoyoData = new ArrayList<Long>();
        for (int i = 0; i < PropertyType.getPayloadSizeLongs() - 1; ++i) {
            theYoyoData.add(Long.MIN_VALUE);
            Long[] value = theYoyoData.toArray(new Long[0]);
            rel.setProperty("yoyo", (Object)value);
            Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
            Assert.assertEquals((long)valueRecordsInUseAtStart, (long)this.dynamicArrayRecordsInUse());
            if (!withNewTx) continue;
            this.newTransaction();
            this.clearCache();
        }
        theYoyoData.add(Long.MIN_VALUE);
        Long[] value = theYoyoData.toArray(new Long[0]);
        rel.setProperty("yoyo", (Object)value);
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((long)(valueRecordsInUseAtStart + 1L), (long)this.dynamicArrayRecordsInUse());
        this.newTransaction();
        this.clearCache();
        rel.setProperty("filler", (Object)new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE});
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    public void testRemoveZigZag() {
        int j;
        int i;
        int propRecCount;
        Relationship rel = this.getGraphDb().createNode().createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"LOCKS"));
        long recordsInUseAtStart = this.propertyRecordsInUse();
        for (propRecCount = 1; propRecCount <= 3; ++propRecCount) {
            for (i = 1; i <= PropertyType.getPayloadSizeLongs(); ++i) {
                rel.setProperty("int" + (propRecCount * 10 + i), (Object)(propRecCount * 10 + i));
                Assert.assertEquals((long)(recordsInUseAtStart + (long)propRecCount), (long)this.propertyRecordsInUse());
            }
        }
        this.newTransaction();
        this.clearCache();
        for (i = 1; i <= PropertyType.getPayloadSizeLongs(); ++i) {
            for (j = 1; j < propRecCount; ++j) {
                Assert.assertEquals((Object)(j * 10 + i), (Object)rel.removeProperty("int" + (j * 10 + i)));
                if (i == PropertyType.getPayloadSize() - 1 && j != propRecCount - 1) {
                    Assert.assertEquals((long)(recordsInUseAtStart + (long)(propRecCount - j)), (long)this.propertyRecordsInUse());
                    continue;
                }
                if (i == PropertyType.getPayloadSize() - 1 && j == propRecCount - 1) {
                    Assert.assertEquals((long)recordsInUseAtStart, (long)this.propertyRecordsInUse());
                    continue;
                }
                Assert.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
            }
        }
        for (i = 1; i <= PropertyType.getPayloadSizeLongs(); ++i) {
            for (j = 1; j < propRecCount; ++j) {
                Assert.assertFalse((boolean)rel.hasProperty("int" + (j * 10 + i)));
            }
        }
        this.newTransaction();
        for (i = 1; i <= PropertyType.getPayloadSizeLongs(); ++i) {
            for (j = 1; j < propRecCount; ++j) {
                Assert.assertFalse((boolean)rel.hasProperty("int" + (j * 10 + i)));
            }
        }
        Assert.assertEquals((long)recordsInUseAtStart, (long)this.propertyRecordsInUse());
    }

    @Test
    public void testSetWithSameValue() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("rev_pos", (Object)"40000633e7ad67ff");
        Assert.assertEquals((Object)"40000633e7ad67ff", (Object)node.getProperty("rev_pos"));
        this.newTransaction();
        this.clearCache();
        node.setProperty("rev_pos", (Object)"40000633e7ad67ef");
        Assert.assertEquals((Object)"40000633e7ad67ef", (Object)node.getProperty("rev_pos"));
    }

    private void testStringYoYoBase(boolean withNewTx) {
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        long valueRecordsInUseAtStart = this.dynamicStringRecordsInUse();
        String data = "0";
        int counter = 1;
        while (this.dynamicStringRecordsInUse() == valueRecordsInUseAtStart) {
            data = data + counter++;
            node.setProperty("yoyo", (Object)data);
            Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
            if (!withNewTx) continue;
            this.newTransaction();
            this.clearCache();
        }
        Assert.assertEquals((long)(valueRecordsInUseAtStart + 1L), (long)this.dynamicStringRecordsInUse());
        data = data.substring(0, data.length() - 2);
        node.setProperty("yoyo", (Object)data);
        this.newTransaction();
        Assert.assertEquals((long)valueRecordsInUseAtStart, (long)this.dynamicStringRecordsInUse());
        Assert.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        node.setProperty("fillerBoolean", (Object)true);
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    public void testStringYoYoWithTx() {
        this.testStringYoYoBase(true);
    }

    @Test
    public void testStringYoYoWithoutTx() {
        this.testStringYoYoBase(false);
    }

    @Test
    public void testRemoveFirstOfTwo() {
        Node node = this.getGraphDb().createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        node.setProperty("Double1", (Object)1.0);
        node.setProperty("Int1", (Object)1);
        node.setProperty("Int2", (Object)2);
        node.setProperty("Int2", (Object)1.2);
        node.setProperty("Int2", (Object)2);
        node.setProperty("Double3", (Object)3.0);
        Assert.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((Object)new Double(1.0), (Object)node.getProperty("Double1"));
        Assert.assertEquals((Object)new Integer(1), (Object)node.getProperty("Int1"));
        Assert.assertEquals((Object)new Integer(2), (Object)node.getProperty("Int2"));
        Assert.assertEquals((Object)new Double(3.0), (Object)node.getProperty("Double3"));
    }

    @Test
    public void deleteNodeWithNewPropertyRecordShouldFreeTheNewRecord() throws Exception {
        long propcount = this.getNodeManager().getNumberOfIdsInUse(PropertyStore.class);
        Node node = this.getGraphDb().createNode();
        node.setProperty("one", (Object)1);
        node.setProperty("two", (Object)2);
        node.setProperty("three", (Object)3);
        node.setProperty("four", (Object)4);
        Assert.assertEquals((String)"Invalid assumption: property record count", (long)(propcount + 1L), (long)this.getNodeManager().getNumberOfIdsInUse(PropertyStore.class));
        this.newTransaction();
        Assert.assertEquals((String)"Invalid assumption: property record count", (long)(propcount + 1L), (long)this.getNodeManager().getNumberOfIdsInUse(PropertyStore.class));
        node.setProperty("final", (Object)666);
        Assert.assertEquals((String)"Invalid assumption: property record count", (long)(propcount + 2L), (long)this.getNodeManager().getNumberOfIdsInUse(PropertyStore.class));
        node.delete();
        this.commit();
        Assert.assertEquals((String)"All property records should be freed", (long)propcount, (long)this.getNodeManager().getNumberOfIdsInUse(PropertyStore.class));
    }
}

