/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;

@Ignore(value="Not a proper test really, merely a contention measurement")
public class TestPersistenceWindowPoolContention {
    private static final int recordSize = 30;
    private static final long mappingSize = TestPersistenceWindowPoolContention.giga(1L);
    private long fileSize = TestPersistenceWindowPoolContention.mega(800L);
    private FileChannel channel;
    private PersistenceWindowPool pool;
    private final Map<Long, Long> values = new ConcurrentHashMap<Long, Long>();

    @Before
    public void before() throws Exception {
        File file = new File("target/bigfile");
        file.delete();
        this.channel = new RandomAccessFile(file, "rw").getChannel();
        this.write(this.channel, this.fileSize);
        this.pool = new PersistenceWindowPool("contention test", 30, this.channel, mappingSize, true, false);
    }

    private void write(FileChannel channel, long bytes) throws IOException {
        channel.position(bytes);
        channel.write(ByteBuffer.wrap(new byte[1]));
        channel.position(0L);
        channel.force(true);
    }

    @After
    public void after() throws Exception {
        Method closeMethod = this.pool.getClass().getDeclaredMethod("close", new Class[0]);
        closeMethod.setAccessible(true);
        closeMethod.invoke((Object)this.pool, new Object[0]);
        this.channel.close();
    }

    private static long kilo(long i) {
        return i * 1024L;
    }

    private static long mega(long i) {
        return TestPersistenceWindowPoolContention.kilo(TestPersistenceWindowPoolContention.kilo(i));
    }

    private static long giga(long i) {
        return TestPersistenceWindowPoolContention.mega(TestPersistenceWindowPoolContention.kilo(i));
    }

    @Test
    public void triggerContentionAmongstPersistenceWindows() throws Exception {
        ArrayList<Worker> workers = new ArrayList<Worker>();
        for (int i = 0; i < 8; ++i) {
            Worker worker = new Worker();
            workers.add(worker);
            worker.start();
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(180L);
        int tick = 2;
        while (System.currentTimeMillis() < endTime) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(tick));
            System.out.println(this.getPoolStats());
            this.fileSize += TestPersistenceWindowPoolContention.mega(tick);
        }
        for (Worker worker : workers) {
            worker.halted = true;
        }
        long total = 0L;
        for (Worker putter : workers) {
            total += putter.waitForEnd();
        }
        System.out.println("total:" + total);
    }

    private String getPoolStats() throws Exception {
        Method method = this.pool.getClass().getDeclaredMethod("getStats", new Class[0]);
        method.setAccessible(true);
        return method.invoke((Object)this.pool, new Object[0]).toString();
    }

    private class Worker
    extends Thread {
        private volatile boolean halted;
        private final Random random = new Random();
        private long count;

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            this.warmItUp();
            while (!this.halted) {
                type = this.randomOperationTypeButFavoringReads(0.6f);
                id = this.randomPosition();
                window = TestPersistenceWindowPoolContention.access$300(TestPersistenceWindowPoolContention.this).acquire(id, type);
                try {
                    switch (1.$SwitchMap$org$neo4j$kernel$impl$nioneo$store$OperationType[type.ordinal()]) {
                        case 1: {
                            this.readStuff(window, id);
                            ** break;
lbl11:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.writeStuff(window, id);
                            break;
                        }
                        ** default:
lbl16:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    TestPersistenceWindowPoolContention.access$300(TestPersistenceWindowPoolContention.this).release(window);
                }
                ++this.count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void warmItUp() {
            for (int i = 0; i < 100000; ++i) {
                long id = this.randomPosition();
                PersistenceWindow window = TestPersistenceWindowPoolContention.this.pool.acquire(id, OperationType.READ);
                try {
                    this.readStuff(window, id);
                    continue;
                }
                finally {
                    TestPersistenceWindowPoolContention.this.pool.release(window);
                }
            }
        }

        private synchronized long waitForEnd() throws InterruptedException {
            this.join();
            return this.count;
        }

        private void readStuff(PersistenceWindow window, long id) {
            Buffer buffer = window.getOffsettedBuffer(id);
            long read = buffer.getLong();
            Long existingValue = (Long)TestPersistenceWindowPoolContention.this.values.get(id);
            if (existingValue != null) {
                Assert.assertEquals((long)existingValue, (long)read);
            }
        }

        private void writeStuff(PersistenceWindow window, long id) {
            Buffer buffer = window.getOffsettedBuffer(id);
            long value = this.random.nextLong();
            buffer.putLong(value);
            TestPersistenceWindowPoolContention.this.values.put(id, value);
        }

        private long randomPosition() {
            return this.random.nextInt((int)(TestPersistenceWindowPoolContention.this.fileSize / 30L));
        }

        private OperationType randomOperationTypeButFavoringReads(float percentageReads) {
            return this.random.nextFloat() <= percentageReads ? OperationType.READ : OperationType.WRITE;
        }
    }
}

