/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.PlaceboTm;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.DefaultLogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class TestNeoStore
extends AbstractNeo4jTestCase {
    private PropertyStore pStore;
    private RelationshipTypeStore rtStore;
    private NeoStoreXaDataSource ds;
    private NeoStoreXaConnection xaCon;
    private Xid dummyXid;
    private byte txCount = 0;
    XAResource xaResource;

    @Override
    protected boolean restartGraphDbBetweenTests() {
        return true;
    }

    private String path() {
        String path = AbstractNeo4jTestCase.getStorePath("test-neostore");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    @Before
    public void setUpNeoStore() throws Exception {
        TestNeoStore.deleteFileOrDirectory(this.path());
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        Config config = new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(new HashMap()));
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (FileSystemAbstraction)fileSystem, null, StringLogger.SYSTEM, null);
        sf.createNeoStore(this.file("neo")).close();
    }

    private PropertyIndex createDummyIndex(int id, String key) {
        MyPropertyIndex index = new MyPropertyIndex(key, id);
        MyPropertyIndex.add(index);
        return index;
    }

    private void initializeStores() throws IOException {
        LockManager lockManager = this.getEmbeddedGraphDb().getLockManager();
        LockReleaser lockReleaser = this.getEmbeddedGraphDb().getLockReleaser();
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        Config config = new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(MapUtil.stringMap((String[])new String[]{InternalAbstractGraphDatabase.Configuration.store_dir.name(), this.path(), InternalAbstractGraphDatabase.Configuration.neo_store.name(), this.file("neo"), InternalAbstractGraphDatabase.Configuration.logical_log.name(), this.file("nioneo_logical.log")})));
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (FileSystemAbstraction)fileSystem, null, StringLogger.DEV_NULL, null);
        this.ds = new NeoStoreXaDataSource(config, sf, (FileSystemAbstraction)fileSystem, lockManager, lockReleaser, StringLogger.DEV_NULL, new XaFactory(config, TxIdGenerator.DEFAULT, (AbstractTransactionManager)new PlaceboTm(), (LogBufferFactory)new DefaultLogBufferFactory(), (FileSystemAbstraction)fileSystem, StringLogger.DEV_NULL, RecoveryVerifier.ALWAYS_VALID, LogPruneStrategies.NO_PRUNING), Collections.emptyList(), null);
        this.xaCon = this.ds.getXaConnection();
        this.pStore = this.xaCon.getPropertyStore();
        this.rtStore = this.xaCon.getRelationshipTypeStore();
    }

    private void startTx() throws XAException {
        this.dummyXid = new XidImpl(new byte[this.txCount], new byte[this.txCount]);
        this.txCount = (byte)(this.txCount + 1);
        this.xaResource = this.xaCon.getXaResource();
        this.xaResource.start(this.dummyXid, 0);
    }

    private void commitTx() throws XAException {
        this.xaResource.end(this.dummyXid, 0x4000000);
        this.xaResource.commit(this.dummyXid, true);
    }

    @After
    public void tearDownNeoStore() {
        File file = new File(this.file("neo"));
        file.delete();
        file = new File(this.file("neo.id"));
        file.delete();
        file = new File(this.file("neo.nodestore.db"));
        file.delete();
        file = new File(this.file("neo.nodestore.db.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.index"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.index.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.index.keys"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.index.keys.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.strings"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.strings.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.arrays"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.arrays.id"));
        file.delete();
        file = new File(this.file("neo.relationshipstore.db"));
        file.delete();
        file = new File(this.file("neo.relationshipstore.db.id"));
        file.delete();
        file = new File(this.file("neo.relationshiptypestore.db"));
        file.delete();
        file = new File(this.file("neo.relationshiptypestore.db.id"));
        file.delete();
        file = new File(this.file("neo.relationshiptypestore.db.names"));
        file.delete();
        file = new File(this.file("neo.relationshiptypestore.db.names.id"));
        file.delete();
        file = new File(".");
        for (File nioFile : file.listFiles()) {
            if (!nioFile.getName().startsWith("nioneo_logical.log")) continue;
            nioFile.delete();
        }
    }

    private PropertyIndex index(String key) {
        Iterator<PropertyIndex> itr = MyPropertyIndex.index(key).iterator();
        if (!itr.hasNext()) {
            int id = (int)this.ds.nextId(PropertyIndex.class);
            PropertyIndex index = this.createDummyIndex(id, key);
            this.xaCon.getWriteTransaction().createPropertyIndex(key, id);
            return index;
        }
        return itr.next();
    }

    @Test
    public void testCreateNeoStore() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(node2);
        PropertyData n1prop1 = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        PropertyData n1prop2 = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop2"), (Object)1);
        PropertyData n1prop3 = this.xaCon.getWriteTransaction().nodeAddProperty(node1, this.index("prop3"), (Object)true);
        PropertyData n2prop1 = this.xaCon.getWriteTransaction().nodeAddProperty(node2, this.index("prop1"), (Object)"string2");
        PropertyData n2prop2 = this.xaCon.getWriteTransaction().nodeAddProperty(node2, this.index("prop2"), (Object)2);
        PropertyData n2prop3 = this.xaCon.getWriteTransaction().nodeAddProperty(node2, this.index("prop3"), (Object)false);
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getWriteTransaction().createRelationshipType(relType1, "relationshiptype1");
        int relType2 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getWriteTransaction().createRelationshipType(relType2, "relationshiptype2");
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel1, relType1, node1, node2);
        long rel2 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel2, relType2, node2, node1);
        PropertyData r1prop1 = this.xaCon.getWriteTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        PropertyData r1prop2 = this.xaCon.getWriteTransaction().relAddProperty(rel1, this.index("prop2"), (Object)1);
        PropertyData r1prop3 = this.xaCon.getWriteTransaction().relAddProperty(rel1, this.index("prop3"), (Object)true);
        PropertyData r2prop1 = this.xaCon.getWriteTransaction().relAddProperty(rel2, this.index("prop1"), (Object)"string2");
        PropertyData r2prop2 = this.xaCon.getWriteTransaction().relAddProperty(rel2, this.index("prop2"), (Object)2);
        PropertyData r2prop3 = this.xaCon.getWriteTransaction().relAddProperty(rel2, this.index("prop3"), (Object)false);
        this.commitTx();
        this.ds.close();
        this.initializeStores();
        this.startTx();
        this.validateNodeRel1(node1, n1prop1, n1prop2, n1prop3, rel1, rel2, relType1, relType2);
        this.validateNodeRel2(node2, n2prop1, n2prop2, n2prop3, rel1, rel2, relType1, relType2);
        this.validateRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.validateRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.commitTx();
        this.ds.close();
        this.initializeStores();
        this.startTx();
        this.deleteRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.deleteRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.deleteNode1(node1, n1prop1, n1prop2, n1prop3);
        this.deleteNode2(node2, n2prop1, n2prop2, n2prop3);
        this.commitTx();
        this.ds.close();
        this.initializeStores();
        this.startTx();
        Assert.assertNull((Object)this.xaCon.getWriteTransaction().nodeLoadLight(node1));
        Assert.assertNull((Object)this.xaCon.getWriteTransaction().nodeLoadLight(node2));
        this.testGetRels(new long[]{rel1, rel2});
        long[] nodeIds = new long[10];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.xaCon.getWriteTransaction().nodeCreate(nodeIds[i]);
            this.xaCon.getWriteTransaction().nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            long id = this.ds.nextId(Relationship.class);
            this.xaCon.getWriteTransaction().relationshipCreate(id, relType1, nodeIds[i], nodeIds[i + 1]);
            this.xaCon.getWriteTransaction().relDelete(id);
        }
        for (i = 0; i < 3; ++i) {
            AtomicLong pos = this.getPosition(this.xaCon, nodeIds[i]);
            for (RelationshipRecord rel : this.getMore(this.xaCon, nodeIds[i], pos)) {
                this.xaCon.getWriteTransaction().relDelete(rel.getId());
            }
            this.xaCon.getWriteTransaction().nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.close();
    }

    private AtomicLong getPosition(NeoStoreXaConnection xaCon, long node) {
        return new AtomicLong(xaCon.getWriteTransaction().getRelationshipChainPosition(node));
    }

    private Iterable<RelationshipRecord> getMore(NeoStoreXaConnection xaCon, long node, AtomicLong pos) {
        Pair rels = xaCon.getWriteTransaction().getMoreRelationships(node, pos.get());
        pos.set((Long)rels.other());
        ArrayList list = new ArrayList();
        for (Map.Entry entry : ((Map)rels.first()).entrySet()) {
            list.add(entry.getValue());
        }
        return new CombiningIterable(list);
    }

    private void validateNodeRel1(long node, PropertyData prop1, PropertyData prop2, PropertyData prop3, long rel1, long rel2, int relType1, int relType2) throws IOException {
        Iterable<RelationshipRecord> relData;
        NodeRecord nodeRecord = this.xaCon.getWriteTransaction().nodeLoadLight(node);
        Assert.assertTrue((nodeRecord != null ? 1 : 0) != 0);
        ArrayMap props = this.xaCon.getWriteTransaction().nodeLoadProperties(node, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((PropertyData)props.get((Object)keyId)).getIndex());
            PropertyData data = block.newPropertyData(record);
            if (data.getIndex() == prop1.getIndex()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"string1", (Object)data.getValue());
                this.xaCon.getWriteTransaction().nodeChangeProperty(node, prop1, (Object)"-string1");
            } else if (data.getIndex() == prop2.getIndex()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(1), (Object)data.getValue());
                this.xaCon.getWriteTransaction().nodeChangeProperty(node, prop2, (Object)new Integer(-1));
            } else if (data.getIndex() == prop3.getIndex()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(true), (Object)data.getValue());
                this.xaCon.getWriteTransaction().nodeChangeProperty(node, prop3, (Object)new Boolean(false));
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        AtomicLong pos = this.getPosition(this.xaCon, node);
        while ((relData = this.getMore(this.xaCon, node, pos)).iterator().hasNext()) {
            for (RelationshipRecord rel : relData) {
                if (rel.getId() == rel1) {
                    Assert.assertEquals((long)node, (long)rel.getFirstNode());
                    Assert.assertEquals((long)relType1, (long)rel.getType());
                } else if (rel.getId() == rel2) {
                    Assert.assertEquals((long)node, (long)rel.getSecondNode());
                    Assert.assertEquals((long)relType2, (long)rel.getType());
                } else {
                    throw new IOException();
                }
                ++count;
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private void validateNodeRel2(long node, PropertyData prop1, PropertyData prop2, PropertyData prop3, long rel1, long rel2, int relType1, int relType2) throws IOException {
        Iterable<RelationshipRecord> relData;
        NodeRecord nodeRecord = this.xaCon.getWriteTransaction().nodeLoadLight(node);
        Assert.assertTrue((nodeRecord != null ? 1 : 0) != 0);
        ArrayMap props = this.xaCon.getWriteTransaction().nodeLoadProperties(node, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((PropertyData)props.get((Object)keyId)).getIndex());
            PropertyData data = block.newPropertyData(record);
            if (data.getIndex() == prop1.getIndex()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"string2", (Object)data.getValue());
                this.xaCon.getWriteTransaction().nodeChangeProperty(node, prop1, (Object)"-string2");
            } else if (data.getIndex() == prop2.getIndex()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(2), (Object)data.getValue());
                this.xaCon.getWriteTransaction().nodeChangeProperty(node, prop2, (Object)new Integer(-2));
            } else if (data.getIndex() == prop3.getIndex()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(false), (Object)data.getValue());
                this.xaCon.getWriteTransaction().nodeChangeProperty(node, prop3, (Object)new Boolean(true));
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        AtomicLong pos = this.getPosition(this.xaCon, node);
        while ((relData = this.getMore(this.xaCon, node, pos)).iterator().hasNext()) {
            for (RelationshipRecord rel : relData) {
                if (rel.getId() == rel1) {
                    Assert.assertEquals((long)node, (long)rel.getSecondNode());
                    Assert.assertEquals((long)relType1, (long)rel.getType());
                } else if (rel.getId() == rel2) {
                    Assert.assertEquals((long)node, (long)rel.getFirstNode());
                    Assert.assertEquals((long)relType2, (long)rel.getType());
                } else {
                    throw new IOException();
                }
                ++count;
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private void validateRel1(long rel, PropertyData prop1, PropertyData prop2, PropertyData prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = this.xaCon.getWriteTransaction().relLoadProperties(rel, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((PropertyData)props.get((Object)keyId)).getIndex());
            PropertyData data = block.newPropertyData(record);
            if (data.getIndex() == prop1.getIndex()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"string1", (Object)data.getValue());
                this.xaCon.getWriteTransaction().relChangeProperty(rel, prop1, (Object)"-string1");
            } else if (data.getIndex() == prop2.getIndex()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(1), (Object)data.getValue());
                this.xaCon.getWriteTransaction().relChangeProperty(rel, prop2, (Object)new Integer(-1));
            } else if (data.getIndex() == prop3.getIndex()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(true), (Object)data.getValue());
                this.xaCon.getWriteTransaction().relChangeProperty(rel, prop3, (Object)new Boolean(false));
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        RelationshipRecord relData = this.xaCon.getWriteTransaction().relLoadLight(rel);
        Assert.assertEquals((long)firstNode, (long)relData.getFirstNode());
        Assert.assertEquals((long)secondNode, (long)relData.getSecondNode());
        Assert.assertEquals((long)relType, (long)relData.getType());
    }

    private void validateRel2(long rel, PropertyData prop1, PropertyData prop2, PropertyData prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = this.xaCon.getWriteTransaction().relLoadProperties(rel, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((PropertyData)props.get((Object)keyId)).getIndex());
            PropertyData data = block.newPropertyData(record);
            if (data.getIndex() == prop1.getIndex()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"string2", (Object)data.getValue());
                this.xaCon.getWriteTransaction().relChangeProperty(rel, prop1, (Object)"-string2");
            } else if (data.getIndex() == prop2.getIndex()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(2), (Object)data.getValue());
                this.xaCon.getWriteTransaction().relChangeProperty(rel, prop2, (Object)new Integer(-2));
            } else if (data.getIndex() == prop3.getIndex()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(false), (Object)data.getValue());
                this.xaCon.getWriteTransaction().relChangeProperty(rel, prop3, (Object)new Boolean(true));
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        RelationshipRecord relData = this.xaCon.getWriteTransaction().relLoadLight(rel);
        Assert.assertEquals((long)firstNode, (long)relData.getFirstNode());
        Assert.assertEquals((long)secondNode, (long)relData.getSecondNode());
        Assert.assertEquals((long)relType, (long)relData.getType());
    }

    private void validateRelTypes(int relType1, int relType2) throws IOException {
        NameData data = this.rtStore.getName(relType1);
        Assert.assertEquals((long)relType1, (long)data.getId());
        Assert.assertEquals((Object)"relationshiptype1", (Object)data.getName());
        data = this.rtStore.getName(relType2);
        Assert.assertEquals((long)relType2, (long)data.getId());
        Assert.assertEquals((Object)"relationshiptype2", (Object)data.getName());
        NameData[] allData = this.rtStore.getNames(Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)allData.length);
        for (int i = 0; i < 2; ++i) {
            if (allData[i].getId() == relType1) {
                Assert.assertEquals((long)relType1, (long)allData[i].getId());
                Assert.assertEquals((Object)"relationshiptype1", (Object)allData[i].getName());
                continue;
            }
            if (allData[i].getId() == relType2) {
                Assert.assertEquals((long)relType2, (long)allData[i].getId());
                Assert.assertEquals((Object)"relationshiptype2", (Object)allData[i].getName());
                continue;
            }
            throw new IOException();
        }
    }

    private void deleteRel1(long rel, PropertyData prop1, PropertyData prop2, PropertyData prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = this.xaCon.getWriteTransaction().relLoadProperties(rel, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((PropertyData)props.get((Object)keyId)).getIndex());
            PropertyData data = block.newPropertyData(record);
            if (data.getIndex() == prop1.getIndex()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"-string1", (Object)data.getValue());
            } else if (data.getIndex() == prop2.getIndex()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(-1), (Object)data.getValue());
            } else if (data.getIndex() == prop3.getIndex()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(false), (Object)data.getValue());
                this.xaCon.getWriteTransaction().relRemoveProperty(rel, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertEquals((long)3L, (long)this.xaCon.getWriteTransaction().relLoadProperties(rel, false).size());
        RelationshipRecord relData = this.xaCon.getWriteTransaction().relLoadLight(rel);
        Assert.assertEquals((long)firstNode, (long)relData.getFirstNode());
        Assert.assertEquals((long)secondNode, (long)relData.getSecondNode());
        Assert.assertEquals((long)relType, (long)relData.getType());
        this.xaCon.getWriteTransaction().relDelete(rel);
        AtomicLong firstPos = this.getPosition(this.xaCon, firstNode);
        Iterator<RelationshipRecord> first = this.getMore(this.xaCon, firstNode, firstPos).iterator();
        first.next();
        AtomicLong secondPos = this.getPosition(this.xaCon, secondNode);
        Iterator<RelationshipRecord> second = this.getMore(this.xaCon, secondNode, secondPos).iterator();
        second.next();
        Assert.assertTrue((boolean)first.hasNext());
        Assert.assertTrue((boolean)second.hasNext());
    }

    private void deleteRel2(long rel, PropertyData prop1, PropertyData prop2, PropertyData prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = this.xaCon.getWriteTransaction().relLoadProperties(rel, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((PropertyData)props.get((Object)keyId)).getIndex());
            PropertyData data = block.newPropertyData(record);
            if (data.getIndex() == prop1.getIndex()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"-string2", (Object)data.getValue());
            } else if (data.getIndex() == prop2.getIndex()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(-2), (Object)data.getValue());
            } else if (data.getIndex() == prop3.getIndex()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(true), (Object)data.getValue());
                this.xaCon.getWriteTransaction().relRemoveProperty(rel, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertEquals((long)3L, (long)this.xaCon.getWriteTransaction().relLoadProperties(rel, false).size());
        RelationshipRecord relData = this.xaCon.getWriteTransaction().relLoadLight(rel);
        Assert.assertEquals((long)firstNode, (long)relData.getFirstNode());
        Assert.assertEquals((long)secondNode, (long)relData.getSecondNode());
        Assert.assertEquals((long)relType, (long)relData.getType());
        this.xaCon.getWriteTransaction().relDelete(rel);
        AtomicLong firstPos = this.getPosition(this.xaCon, firstNode);
        Iterator<RelationshipRecord> first = this.getMore(this.xaCon, firstNode, firstPos).iterator();
        AtomicLong secondPos = this.getPosition(this.xaCon, secondNode);
        Iterator<RelationshipRecord> second = this.getMore(this.xaCon, secondNode, secondPos).iterator();
        Assert.assertTrue((boolean)first.hasNext());
        Assert.assertTrue((boolean)second.hasNext());
    }

    private void deleteNode1(long node, PropertyData prop1, PropertyData prop2, PropertyData prop3) throws IOException {
        ArrayMap props = this.xaCon.getWriteTransaction().nodeLoadProperties(node, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((PropertyData)props.get((Object)keyId)).getIndex());
            PropertyData data = block.newPropertyData(record);
            if (data.getIndex() == prop1.getIndex()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"-string1", (Object)data.getValue());
            } else if (data.getIndex() == prop2.getIndex()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(-1), (Object)data.getValue());
            } else if (data.getIndex() == prop3.getIndex()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(false), (Object)data.getValue());
                this.xaCon.getWriteTransaction().nodeRemoveProperty(node, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertEquals((long)3L, (long)this.xaCon.getWriteTransaction().nodeLoadProperties(node, false).size());
        AtomicLong pos = this.getPosition(this.xaCon, node);
        Iterator<RelationshipRecord> rels = this.getMore(this.xaCon, node, pos).iterator();
        Assert.assertTrue((boolean)rels.hasNext());
        this.xaCon.getWriteTransaction().nodeDelete(node);
    }

    private void deleteNode2(long node, PropertyData prop1, PropertyData prop2, PropertyData prop3) throws IOException {
        ArrayMap props = this.xaCon.getWriteTransaction().nodeLoadProperties(node, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((PropertyData)props.get((Object)keyId)).getIndex());
            PropertyData data = block.newPropertyData(record);
            if (data.getIndex() == prop1.getIndex()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"-string2", (Object)data.getValue());
            } else if (data.getIndex() == prop2.getIndex()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(-2), (Object)data.getValue());
            } else if (data.getIndex() == prop3.getIndex()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(true), (Object)data.getValue());
                this.xaCon.getWriteTransaction().nodeRemoveProperty(node, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertEquals((long)3L, (long)this.xaCon.getWriteTransaction().nodeLoadProperties(node, false).size());
        AtomicLong pos = this.getPosition(this.xaCon, node);
        Iterator<RelationshipRecord> rels = this.getMore(this.xaCon, node, pos).iterator();
        Assert.assertTrue((boolean)rels.hasNext());
        this.xaCon.getWriteTransaction().nodeDelete(node);
    }

    private void testGetRels(long[] relIds) {
        for (long relId : relIds) {
            Assert.assertEquals(null, (Object)this.xaCon.getWriteTransaction().relLoadLight(relId));
        }
    }

    @Test
    public void testRels1() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getWriteTransaction().createRelationshipType(relType1, "relationshiptype1");
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.xaCon.getWriteTransaction().nodeCreate(nodeIds[i]);
            this.xaCon.getWriteTransaction().nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.xaCon.getWriteTransaction().relationshipCreate(this.ds.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; i += 2) {
            AtomicLong pos = this.getPosition(this.xaCon, nodeIds[i]);
            for (RelationshipRecord rel : this.getMore(this.xaCon, nodeIds[i], pos)) {
                this.xaCon.getWriteTransaction().relDelete(rel.getId());
            }
            this.xaCon.getWriteTransaction().nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.close();
    }

    @Test
    @Ignore
    public void testRels2() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getWriteTransaction().createRelationshipType(relType1, "relationshiptype1");
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.xaCon.getWriteTransaction().nodeCreate(nodeIds[i]);
            this.xaCon.getWriteTransaction().nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.xaCon.getWriteTransaction().relationshipCreate(this.ds.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.xaCon.getWriteTransaction().relationshipCreate(this.ds.nextId(Relationship.class), relType1, nodeIds[0], nodeIds[2]);
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; ++i) {
            AtomicLong pos = this.getPosition(this.xaCon, nodeIds[i]);
            for (RelationshipRecord rel : this.getMore(this.xaCon, nodeIds[i], pos)) {
                this.xaCon.getWriteTransaction().relDelete(rel.getId());
            }
            this.xaCon.getWriteTransaction().nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.close();
    }

    @Test
    public void testRels3() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getWriteTransaction().createRelationshipType(relType1, "relationshiptype1");
        long[] nodeIds = new long[8];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.xaCon.getWriteTransaction().nodeCreate(nodeIds[i]);
        }
        for (i = 0; i < nodeIds.length / 2; ++i) {
            this.xaCon.getWriteTransaction().relationshipCreate(this.ds.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i * 2]);
        }
        long rel5 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel5, relType1, nodeIds[0], nodeIds[5]);
        long rel2 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel2, relType1, nodeIds[1], nodeIds[2]);
        long rel3 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel3, relType1, nodeIds[1], nodeIds[3]);
        long rel6 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel6, relType1, nodeIds[1], nodeIds[6]);
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel1, relType1, nodeIds[0], nodeIds[1]);
        long rel4 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel4, relType1, nodeIds[0], nodeIds[4]);
        long rel7 = this.ds.nextId(Relationship.class);
        this.xaCon.getWriteTransaction().relationshipCreate(rel7, relType1, nodeIds[0], nodeIds[7]);
        this.commitTx();
        this.startTx();
        this.xaCon.getWriteTransaction().relDelete(rel7);
        this.xaCon.getWriteTransaction().relDelete(rel4);
        this.xaCon.getWriteTransaction().relDelete(rel1);
        this.xaCon.getWriteTransaction().relDelete(rel6);
        this.xaCon.getWriteTransaction().relDelete(rel3);
        this.xaCon.getWriteTransaction().relDelete(rel2);
        this.xaCon.getWriteTransaction().relDelete(rel5);
        this.commitTx();
        this.ds.close();
    }

    @Test
    public void testProps1() throws Exception {
        this.initializeStores();
        this.startTx();
        long nodeId = this.ds.nextId(Node.class);
        this.xaCon.getWriteTransaction().nodeCreate(nodeId);
        long propertyId = this.pStore.nextId();
        PropertyData prop = this.xaCon.getWriteTransaction().nodeAddProperty(nodeId, this.index("nisse"), (Object)new Integer(10));
        this.commitTx();
        this.ds.close();
        this.initializeStores();
        this.startTx();
        this.xaCon.getWriteTransaction().nodeChangeProperty(nodeId, prop, (Object)new Integer(5));
        this.xaCon.getWriteTransaction().nodeRemoveProperty(nodeId, prop);
        this.xaCon.getWriteTransaction().nodeDelete(nodeId);
        this.commitTx();
        this.ds.close();
    }

    @Test
    public void testSetBlockSize() throws Exception {
        this.tearDownNeoStore();
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        Config config = new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(MapUtil.stringMap((String[])new String[]{"string_block_size", "62", "array_block_size", "302"})));
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (FileSystemAbstraction)fileSystem, null, StringLogger.DEV_NULL, null);
        sf.createNeoStore(this.file("neo")).close();
        this.initializeStores();
        Assert.assertEquals((long)70L, (long)this.pStore.getStringBlockSize());
        Assert.assertEquals((long)310L, (long)this.pStore.getArrayBlockSize());
        this.ds.close();
    }

    @Test
    public void setVersion() throws Exception {
        String storeDir = "target/test-data/set-version";
        FileUtils.deleteRecursively((File)new File(storeDir));
        new GraphDatabaseFactory().newEmbeddedDatabase(storeDir).shutdown();
        Assert.assertEquals((long)1L, (long)NeoStore.setVersion((String)storeDir, (long)10L));
        Assert.assertEquals((long)10L, (long)NeoStore.setVersion((String)storeDir, (long)12L));
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        StoreFactory sf = new StoreFactory(new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(new HashMap())), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (FileSystemAbstraction)fileSystem, null, StringLogger.DEV_NULL, null);
        NeoStore neoStore = sf.newNeoStore(new File(storeDir, "neostore").getAbsolutePath());
        Assert.assertEquals((long)12L, (long)neoStore.getVersion());
        neoStore.close();
    }

    private static class MyPropertyIndex
    extends PropertyIndex {
        private static Map<String, PropertyIndex> stringToIndex = new HashMap<String, PropertyIndex>();
        private static Map<Integer, PropertyIndex> intToIndex = new HashMap<Integer, PropertyIndex>();

        protected MyPropertyIndex(String key, int keyId) {
            super(key, keyId);
        }

        public static Iterable<PropertyIndex> index(String key) {
            if (stringToIndex.containsKey(key)) {
                return Arrays.asList(stringToIndex.get(key));
            }
            return Collections.emptyList();
        }

        public static PropertyIndex getIndexFor(int index) {
            return intToIndex.get(index);
        }

        public static void add(MyPropertyIndex index) {
            stringToIndex.put(index.getKey(), index);
            intToIndex.put(index.getKeyId(), index);
        }
    }
}

