/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Suite;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcessTestRunner;
import org.neo4j.tooling.GlobalGraphOperations;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={FailureBeforeRebuild.class, FailureDuringRebuild.class})
public class IdGeneratorRebuildFailureEmulationTest {
    private FileSystem fs;
    private StoreFactory factory;
    private String prefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BreakpointTrigger
    private void performTest() throws Exception {
        String file = this.prefix + File.separator + Thread.currentThread().getStackTrace()[2].getMethodName().replace('_', '.');
        this.fs.deleteFile(file + ".id");
        NeoStore neostore = null;
        try {
            neostore = this.factory.newNeoStore(this.prefix + File.separator + "neostore");
            this.emulateFailureOnRebuildOf(neostore);
        }
        catch (UnderlyingStorageException expected) {
            Assert.assertEquals((Object)"Id capacity exceeded", (Object)expected.getMessage());
        }
        finally {
            if (neostore != null) {
                neostore.close();
            }
        }
    }

    void emulateFailureOnRebuildOf(NeoStore neostore) {
        Assert.fail((String)"emulateFailureOnRebuildOf(NeoStore) must be overridden");
    }

    @Before
    public void initialize() {
        this.fs = new FileSystem();
        Database graphdb = new Database();
        this.prefix = graphdb.getStoreDir();
        this.createInitialData((GraphDatabaseService)graphdb);
        graphdb.shutdown();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.rebuild_idgenerators_fast.name(), "false");
        this.factory = new StoreFactory(new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(config)), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (FileSystemAbstraction)this.fs, null, StringLogger.SYSTEM, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void verifyAndDispose() throws Exception {
        try {
            Database graphdb = new Database();
            this.verifyData((GraphDatabaseService)graphdb);
            graphdb.shutdown();
        }
        finally {
            if (this.fs != null) {
                this.fs.disposeAndAssertNoOpenFiles();
            }
            this.fs = null;
        }
    }

    private void verifyData(GraphDatabaseService graphdb) {
        int nodecount = 0;
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)graphdb).getAllNodes()) {
            int propcount = this.readProperties((PropertyContainer)node);
            int relcount = 0;
            for (Relationship rel : node.getRelationships()) {
                Assert.assertEquals((String)"all relationships should have 3 properties.", (long)3L, (long)this.readProperties((PropertyContainer)rel));
                ++relcount;
            }
            if (!graphdb.getReferenceNode().equals(node)) {
                Assert.assertEquals((String)"all created nodes should have 3 properties.", (long)3L, (long)propcount);
                Assert.assertEquals((String)"all created nodes should have 2 relationships.", (long)2L, (long)relcount);
            }
            ++nodecount;
        }
        Assert.assertEquals((String)"The database should have 3 nodes.", (long)3L, (long)nodecount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInitialData(GraphDatabaseService graphdb) {
        Transaction tx = graphdb.beginTx();
        try {
            Node first = this.properties(graphdb.createNode());
            Node other = this.properties(graphdb.createNode());
            this.properties(first.createRelationshipTo(other, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS")));
            this.properties(other.createRelationshipTo(first, (RelationshipType)DynamicRelationshipType.withName((String)"DISTRUSTS")));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private <E extends PropertyContainer> E properties(E entity) {
        entity.setProperty("short thing", (Object)"short");
        entity.setProperty("long thing", (Object)"this is quite a long string, don't you think, it sure is long enough at least");
        entity.setProperty("string array", (Object)new String[]{"these are a few", "cool strings", "for your viewing pleasure"});
        return entity;
    }

    private int readProperties(PropertyContainer entity) {
        int count = 0;
        for (String key : entity.getPropertyKeys()) {
            entity.getProperty(key);
            ++count;
        }
        return count;
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_nodestore_db() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db_arrays() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db_index() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db_index_keys() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db_strings() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_relationshipstore_db() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_relationshiptypestore_db() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_relationshiptypestore_db_names() throws Exception {
        this.performTest();
    }

    private IdGeneratorRebuildFailureEmulationTest() {
        if (IdGeneratorRebuildFailureEmulationTest.class == this.getClass()) {
            throw new UnsupportedOperationException("This class is effectively abstract");
        }
    }

    private class Database
    extends ImpermanentGraphDatabase {
        private Database() {
        }

        @Override
        protected FileSystemAbstraction createFileSystemAbstraction() {
            return IdGeneratorRebuildFailureEmulationTest.this.fs;
        }

        @Override
        protected IdGeneratorFactory createIdGeneratorFactory() {
            return new DefaultIdGeneratorFactory();
        }
    }

    private static class FileSystem
    extends EphemeralFileSystemAbstraction {
        private FileSystem() {
        }

        void disposeAndAssertNoOpenFiles() throws Exception {
            this.assertNoOpenFiles();
            super.shutdown();
        }

        @Override
        public void shutdown() {
        }
    }

    @RunWith(value=SubProcessTestRunner.class)
    @ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.nioneo.store.IdGeneratorImpl", method="setHighId")})
    public static final class FailureDuringRebuild
    extends IdGeneratorRebuildFailureEmulationTest {
        @Override
        protected void emulateFailureOnRebuildOf(NeoStore neostore) {
            neostore.makeStoreOk();
            Assert.fail((String)"makeStoreOk should have thrown UnderlyingStorageException");
        }

        @BreakpointHandler(value={"performTest"})
        public static void bootstrapTest(@BreakpointHandler(value={"setHighId"}) BreakPoint setHighId) {
            setHighId.enable();
        }

        @BreakpointHandler(value={"setHighId"})
        public static void on_setHighId(DebugInterface di, BreakPoint setHighId) {
            if (setHighId.invocationCount() > 1 || "org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore".equals(di.thread().getStackTrace()[2].getClassName())) {
                setHighId.disable();
                di.setLocalVariable("id", -1);
            }
        }
    }

    @RunWith(value=JUnit4.class)
    public static final class FailureBeforeRebuild
    extends IdGeneratorRebuildFailureEmulationTest {
        @Override
        protected void emulateFailureOnRebuildOf(NeoStore neostore) {
        }
    }
}

