/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class TestIndexImplOnNeo {
    private EmbeddedGraphDatabase db;
    private String storeDir = TargetDirectory.forTest(this.getClass()).graphDbDir(true).getAbsolutePath();

    @Before
    public void createDb() throws Exception {
        this.db = new EmbeddedGraphDatabase(this.storeDir);
    }

    private void restartDb() throws Exception {
        this.shutdownDb();
        this.createDb();
    }

    @After
    public void shutdownDb() throws Exception {
        this.db.shutdown();
    }

    @Test
    public void createIndexWithProviderThatUsesNeoAsDataSource() throws Exception {
        String indexName = "inneo";
        Assert.assertFalse((boolean)this.db.index().existsForNodes(indexName));
        Map config = MapUtil.stringMap((String[])new String[]{"provider", "test-dummy-neo-index", "config1", "A value", "another config", "Another value"});
        Index index = this.db.index().forNodes(indexName, config);
        Assert.assertTrue((boolean)this.db.index().existsForNodes(indexName));
        Assert.assertEquals((Object)config, (Object)this.db.index().getConfiguration(index));
        Assert.assertEquals((Object)this.db.getReferenceNode(), (Object)index.get("key", (Object)"refnode").getSingle());
        Assert.assertEquals((long)0L, (long)IteratorUtil.count((Iterable)index.get("key", (Object)"something else")));
        this.restartDb();
        Assert.assertTrue((boolean)this.db.index().existsForNodes(indexName));
        Assert.assertEquals((Object)config, (Object)this.db.index().getConfiguration(index));
    }
}

