/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.InternalAbstractGraphDatabase;

public class DummyIndexProvider
extends IndexProvider
implements IndexImplementation {
    static final String IDENTIFIER = "test-dummy-neo-index";
    private InternalAbstractGraphDatabase db;

    public DummyIndexProvider() {
        super(IDENTIFIER);
    }

    public IndexImplementation load(DependencyResolver dependencyResolver) throws Exception {
        this.db = (InternalAbstractGraphDatabase)dependencyResolver.resolveDependency(InternalAbstractGraphDatabase.class);
        return this;
    }

    public String getDataSourceName() {
        return "nioneodb";
    }

    public Index<Node> nodeIndex(String indexName, Map<String, String> config) {
        return new DummyNodeIndex(indexName, this.db);
    }

    public RelationshipIndex relationshipIndex(String indexName, Map<String, String> config) {
        return new DummyRelationshipIndex(indexName, this.db);
    }

    public Map<String, String> fillInDefaults(Map<String, String> config) {
        return config;
    }

    public boolean configMatches(Map<String, String> storedConfig, Map<String, String> config) {
        return true;
    }

    private static class IteratorIndexHits<T>
    implements IndexHits<T> {
        private final List<T> list;
        private final Iterator<T> iterator;

        IteratorIndexHits(List<T> list) {
            this.list = list;
            this.iterator = list.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public T next() {
            return this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
        }

        public Iterator<T> iterator() {
            return this;
        }

        public int size() {
            return this.list.size();
        }

        public void close() {
        }

        public T getSingle() {
            return (T)IteratorUtil.singleOrNull((Iterator)((Object)this));
        }

        public float currentScore() {
            return Float.NaN;
        }
    }

    private class DummyRelationshipIndex
    extends DummyIndex<Relationship>
    implements RelationshipIndex {
        public DummyRelationshipIndex(String name, InternalAbstractGraphDatabase db) {
            super(name, db);
        }

        public Class<Relationship> getEntityType() {
            return Relationship.class;
        }

        public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            throw new UnsupportedOperationException();
        }

        public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            throw new UnsupportedOperationException();
        }

        public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            throw new UnsupportedOperationException();
        }
    }

    private class DummyNodeIndex
    extends DummyIndex<Node> {
        public DummyNodeIndex(String name, InternalAbstractGraphDatabase db) {
            super(name, db);
        }

        public Class<Node> getEntityType() {
            return Node.class;
        }
    }

    private abstract class DummyIndex<T extends PropertyContainer>
    implements Index<T> {
        private final String name;
        private final InternalAbstractGraphDatabase db;

        public DummyIndex(String name, InternalAbstractGraphDatabase db) {
            this.name = name;
            this.db = db;
        }

        public String getName() {
            return this.name;
        }

        public IndexHits<T> get(String key, Object value) {
            if (value.equals("refnode")) {
                return new IteratorIndexHits<PropertyContainer>(Arrays.asList(this.db.getReferenceNode()));
            }
            return new IteratorIndexHits(Collections.emptyList());
        }

        public IndexHits<T> query(String key, Object queryOrQueryObject) {
            throw new UnsupportedOperationException();
        }

        public IndexHits<T> query(Object queryOrQueryObject) {
            throw new UnsupportedOperationException();
        }

        public boolean isWriteable() {
            return false;
        }

        public GraphDatabaseService getGraphDatabase() {
            return null;
        }

        public void add(T entity, String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void remove(T entity, String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void remove(T entity, String key) {
            throw new UnsupportedOperationException();
        }

        public void remove(T entity) {
            throw new UnsupportedOperationException();
        }

        public void delete() {
            throw new UnsupportedOperationException();
        }

        public T putIfAbsent(T entity, String key, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

