/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.test.ImpermanentGraphDatabase;

public class TestTxSuspendResume {
    @Test
    public void testMultipleTxSameThread() throws Exception {
        ImpermanentGraphDatabase graphdb = new ImpermanentGraphDatabase();
        TransactionManager tm = graphdb.getTxManager();
        tm.begin();
        Node refNode = graphdb.getReferenceNode();
        Transaction tx1 = tm.suspend();
        tm.begin();
        refNode.setProperty("test2", (Object)"test");
        Transaction tx2 = tm.suspend();
        tm.resume(tx1);
        CommitThread thread = new CommitThread(tm, tx2, Thread.currentThread());
        thread.start();
        refNode.removeProperty("test2");
        Assert.assertTrue((boolean)thread.success());
        tm.commit();
        graphdb.shutdown();
    }

    private static class CommitThread
    extends Thread {
        private final TransactionManager tm;
        private final Transaction tx;
        private boolean success = false;
        private final Thread main;

        CommitThread(TransactionManager tm, Transaction tx, Thread main) {
            this.tm = tm;
            this.tx = tx;
            this.main = main;
        }

        @Override
        public synchronized void run() {
            try {
                while (this.main.getState() != Thread.State.WAITING) {
                    Thread.sleep(1L);
                }
                this.tm.resume(this.tx);
                this.tm.commit();
                this.success = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        synchronized boolean success() {
            return this.success;
        }
    }
}

