/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;

public class TestRelIdArray {
    @Test
    public void testBasic() throws Exception {
        RelIdArray array = new RelIdArray(null);
        array.add(1L, RelIdArray.DirectionWrapper.OUTGOING);
        array.add(2L, RelIdArray.DirectionWrapper.OUTGOING);
        array.add(3L, RelIdArray.DirectionWrapper.INCOMING);
        RelIdIterator itr = array.iterator(RelIdArray.DirectionWrapper.OUTGOING);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((long)1L, (long)itr.next());
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((long)2L, (long)itr.next());
        Assert.assertFalse((boolean)itr.hasNext());
        Assert.assertFalse((boolean)itr.hasNext());
        itr = array.iterator(RelIdArray.DirectionWrapper.INCOMING);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((long)3L, (long)itr.next());
        Assert.assertFalse((boolean)itr.hasNext());
        itr = array.iterator(RelIdArray.DirectionWrapper.BOTH);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((long)1L, (long)itr.next());
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((long)2L, (long)itr.next());
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((long)3L, (long)itr.next());
        Assert.assertFalse((boolean)itr.hasNext());
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testWithAddRemove() throws Exception {
        RelIdArray source = new RelIdArray(null);
        source.add(1L, RelIdArray.DirectionWrapper.OUTGOING);
        source.add(2L, RelIdArray.DirectionWrapper.OUTGOING);
        source.add(3L, RelIdArray.DirectionWrapper.INCOMING);
        source.add(4L, RelIdArray.DirectionWrapper.INCOMING);
        RelIdArray add = new RelIdArray(null);
        add.add(5L, RelIdArray.DirectionWrapper.OUTGOING);
        add.add(6L, RelIdArray.DirectionWrapper.OUTGOING);
        add.add(7L, RelIdArray.DirectionWrapper.OUTGOING);
        HashSet<Long> remove = new HashSet<Long>();
        remove.add(2L);
        remove.add(6L);
        List<Long> allIds = this.asList(RelIdArray.from((RelIdArray)source, (RelIdArray)add, remove));
        Collections.sort(allIds);
        Assert.assertEquals(Arrays.asList(1L, 3L, 4L, 5L, 7L), allIds);
    }

    @Test
    public void testDifferentBlocks() throws Exception {
        RelIdArray array = new RelIdArray(null);
        long justUnderIntMax = (long)Math.pow(2.0, 32.0) - 3L;
        array.add(justUnderIntMax, RelIdArray.DirectionWrapper.OUTGOING);
        array.add(justUnderIntMax + 1L, RelIdArray.DirectionWrapper.OUTGOING);
        long justOverIntMax = (long)Math.pow(2.0, 32.0) + 3L;
        array.add(justOverIntMax, RelIdArray.DirectionWrapper.OUTGOING);
        array.add(justOverIntMax + 1L, RelIdArray.DirectionWrapper.OUTGOING);
        long aBitOverIntMax = (long)Math.pow(2.0, 33.0);
        array.add(aBitOverIntMax, RelIdArray.DirectionWrapper.OUTGOING);
        array.add(aBitOverIntMax + 1L, RelIdArray.DirectionWrapper.OUTGOING);
        long verySmall = 1000L;
        array.add(verySmall, RelIdArray.DirectionWrapper.OUTGOING);
        array.add(verySmall + 1L, RelIdArray.DirectionWrapper.OUTGOING);
        HashSet<Long> allIds = new HashSet<Long>(this.asList(array));
        Assert.assertEquals(new HashSet<Long>(Arrays.asList(justUnderIntMax, justUnderIntMax + 1L, justOverIntMax, justOverIntMax + 1L, aBitOverIntMax, aBitOverIntMax + 1L, verySmall, verySmall + 1L)), allIds);
    }

    @Test
    public void testAddDifferentBlocks() throws Exception {
        RelIdArray array1 = new RelIdArray(null);
        array1.add(0L, RelIdArray.DirectionWrapper.OUTGOING);
        array1.add(1L, RelIdArray.DirectionWrapper.OUTGOING);
        RelIdArray array2 = new RelIdArray(null);
        long justOverIntMax = (long)Math.pow(2.0, 32.0) + 3L;
        array2.add(justOverIntMax, RelIdArray.DirectionWrapper.OUTGOING);
        array2.add(justOverIntMax + 1L, RelIdArray.DirectionWrapper.OUTGOING);
        RelIdArray all = new RelIdArray(null);
        all.addAll(array1);
        all.addAll(array2);
        Assert.assertEquals(new HashSet<Long>(Arrays.asList(0L, 1L, justOverIntMax, justOverIntMax + 1L)), new HashSet<Long>(this.asList(all)));
    }

    private List<Long> asList(RelIdArray ids) {
        ArrayList<Long> result = new ArrayList<Long>();
        RelIdIterator iterator = ids.iterator(RelIdArray.DirectionWrapper.BOTH);
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }
}

