/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.core.ProduceNonCleanDefraggedStringStore;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

public class TestCrashWithRebuildSlow {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crashAndRebuildSlowWithDynamicStringDeletions() throws Exception {
        String dir = TargetDirectory.forTest(this.getClass()).directory("holes", true).getAbsolutePath();
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), ProduceNonCleanDefraggedStringStore.class.getName(), dir});
        int processResult = new ProcessStreamHandler(process, true).waitForResult();
        Assert.assertEquals((long)0L, (long)processResult);
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dir).setConfig((GraphDatabaseSetting)GraphDatabaseSettings.rebuild_idgenerators_fast, "false").newGraphDatabase();
        try {
            int nameCount = 0;
            int relCount = 0;
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
                if (node.equals(db.getReferenceNode())) continue;
                ++nameCount;
                Assert.assertNotNull((Object)node.getProperty("name"));
                relCount += IteratorUtil.count((Iterable)node.getRelationships(Direction.OUTGOING));
            }
            Assert.assertEquals((long)16L, (long)nameCount);
            Assert.assertEquals((long)12L, (long)relCount);
        }
        finally {
            db.shutdown();
        }
    }
}

