/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.TestXa;

public class TestChangingOfLogFormat {
    @Test
    public void inabilityToStartFromOldFormatFromNonCleanShutdown() throws Exception {
        String storeDir = "target/var/oldlog";
        AbstractNeo4jTestCase.deleteFileOrDirectory(storeDir);
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        Pair<Pair<File, File>, Pair<File, File>> copy = TestXa.copyLogicalLog(storeDir);
        this.decrementLogFormat((File)((Pair)copy.other()).other());
        db.shutdown();
        TestXa.renameCopiedLogicalLog(storeDir);
        try {
            db = new GraphDatabaseFactory().newEmbeddedDatabase(storeDir);
            Assert.fail((String)"Shouldn't be able to do recovery (and upgrade log format version) on non-clean shutdown");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decrementLogFormat(File file) throws IOException {
        RandomAccessFile raFile = new RandomAccessFile(file, "rw");
        FileChannel channel = raFile.getChannel();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[8]);
        channel.read(buffer);
        buffer.flip();
        long version = buffer.getLong();
        long logFormatVersion = version >>> 56;
        long oldVersion = (version &= 0xFFFFFFFFFFFFFFL) | logFormatVersion - 1L << 56;
        channel.position(0L);
        buffer.clear();
        buffer.putLong(oldVersion);
        buffer.flip();
        channel.write(buffer);
        raFile.close();
    }
}

