/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.FileUtils;

public class JumpingFileSystemAbstraction
implements FileSystemAbstraction {
    private final int sizePerJump;

    public JumpingFileSystemAbstraction(int sizePerJump) {
        this.sizePerJump = sizePerJump;
    }

    public FileChannel open(String fileName, String mode) throws IOException {
        if (fileName.endsWith("neostore.nodestore.db") || fileName.endsWith("neostore.relationshipstore.db") || fileName.endsWith("neostore.propertystore.db") || fileName.endsWith("neostore.propertystore.db.strings") || fileName.endsWith("neostore.propertystore.db.arrays")) {
            return new JumpingFileChannel(new RandomAccessFile(fileName, mode).getChannel(), this.recordSizeFor(fileName));
        }
        return new RandomAccessFile(fileName, mode).getChannel();
    }

    public FileChannel create(String fileName) throws IOException {
        return this.open(fileName, "rw");
    }

    public boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public long getFileSize(String fileName) {
        return new File(fileName).length();
    }

    public boolean deleteFile(String fileName) {
        return FileUtils.deleteFile((File)new File(fileName));
    }

    public boolean renameFile(String from, String to) throws IOException {
        return FileUtils.renameFile((File)new File(from), (File)new File(to));
    }

    public void copyFile(String from, String to) throws IOException {
        FileUtils.copyRecursively((File)new File(from), (File)new File(to));
    }

    public org.neo4j.kernel.impl.nioneo.store.FileLock tryLock(String fileName, FileChannel channel) throws IOException {
        return org.neo4j.kernel.impl.nioneo.store.FileLock.getOsSpecificFileLock((String)fileName, (FileChannel)channel);
    }

    private int recordSizeFor(String fileName) {
        if (fileName.endsWith("nodestore.db")) {
            return 9;
        }
        if (fileName.endsWith("relationshipstore.db")) {
            return 33;
        }
        if (fileName.endsWith("propertystore.db.strings") || fileName.endsWith("propertystore.db.arrays")) {
            return AbstractDynamicStore.getRecordSize((int)120);
        }
        if (fileName.endsWith("propertystore.db")) {
            return 41;
        }
        throw new IllegalArgumentException(fileName);
    }

    public class JumpingFileChannel
    extends FileChannel {
        private final FileChannel actual;
        private final int recordSize;

        public JumpingFileChannel(FileChannel actual, int recordSize) {
            this.actual = actual;
            this.recordSize = recordSize;
        }

        private long translateIncoming(long position) {
            return this.translateIncoming(position, false);
        }

        private long translateIncoming(long position, boolean allowFix) {
            long actualRecord = position / (long)this.recordSize;
            if (actualRecord < (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                return position;
            }
            long jumpIndex = (actualRecord + (long)JumpingFileSystemAbstraction.this.sizePerJump) / 0x100000000L;
            long diff = actualRecord - jumpIndex * 0x100000000L;
            diff = this.assertWithinDiff(diff, allowFix);
            long offsettedRecord = jumpIndex * (long)JumpingFileSystemAbstraction.this.sizePerJump + diff;
            return offsettedRecord * (long)this.recordSize;
        }

        private long translateOutgoing(long offsettedPosition) {
            long offsettedRecord = offsettedPosition / (long)this.recordSize;
            if (offsettedRecord < (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                return offsettedPosition;
            }
            long jumpIndex = (offsettedRecord - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) / (long)JumpingFileSystemAbstraction.this.sizePerJump + 1L;
            long diff = (offsettedRecord - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) % (long)JumpingFileSystemAbstraction.this.sizePerJump - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2);
            this.assertWithinDiff(diff, false);
            long actualRecord = jumpIndex * 0x100000000L - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2) + diff;
            return actualRecord * (long)this.recordSize;
        }

        private long assertWithinDiff(long diff, boolean allowFix) {
            if (diff < (long)(-JumpingFileSystemAbstraction.this.sizePerJump / 2) || diff > (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                if (allowFix) {
                    if (diff < (long)(-JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                        return -JumpingFileSystemAbstraction.this.sizePerJump / 2;
                    }
                    return JumpingFileSystemAbstraction.this.sizePerJump / 2;
                }
                throw new IllegalArgumentException("" + diff);
            }
            return diff;
        }

        public long getInternalPosition() throws IOException {
            return this.actual.position();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.actual.read(dst);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.actual.read(dsts, offset, length);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.actual.write(src);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.actual.write(srcs, offset, length);
        }

        @Override
        public long position() throws IOException {
            return this.translateOutgoing(this.actual.position());
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            this.actual.position(this.translateIncoming(newPosition));
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.translateOutgoing(this.actual.size());
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            this.actual.truncate(this.translateIncoming(size, true));
            return this;
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.actual.force(metaData);
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            return this.actual.read(dst, this.translateIncoming(position));
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            return this.actual.write(src, this.translateIncoming(position));
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            return this.actual.lock(this.translateIncoming(position), size, shared);
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return this.actual.tryLock(this.translateIncoming(position), size, shared);
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.actual.close();
        }
    }
}

