/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.TestGraphDatabaseFactory;

@RequiresPersistentGraphDatabase(value=false)
public abstract class AbstractNeo4jTestCase {
    protected static final File NEO4J_BASE_DIR = new File("target", "var");
    @ClassRule
    public static final TestRule START_GRAPHDB = new TestRule(){

        public Statement apply(Statement base, Description description) {
            AbstractNeo4jTestCase.tearDownDb();
            AbstractNeo4jTestCase.setupGraphDatabase(description.getTestClass().getAnnotation(RequiresPersistentGraphDatabase.class).value());
            return base;
        }
    };
    private static GraphDatabaseAPI graphDb;
    private Transaction tx;
    private static boolean requiresPersistentGraphDatabase;

    public GraphDatabaseService getGraphDb() {
        return graphDb;
    }

    private static void setupGraphDatabase(boolean requiresPersistentGraphDatabase) {
        AbstractNeo4jTestCase.requiresPersistentGraphDatabase = requiresPersistentGraphDatabase;
        if (requiresPersistentGraphDatabase) {
            try {
                FileUtils.deleteRecursively((File)new File(AbstractNeo4jTestCase.getStorePath("neo-test")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        graphDb = (GraphDatabaseAPI)(requiresPersistentGraphDatabase ? new TestGraphDatabaseFactory().newEmbeddedDatabase(AbstractNeo4jTestCase.getStorePath("neo-test")) : new TestGraphDatabaseFactory().newImpermanentDatabase());
    }

    public GraphDatabaseAPI getEmbeddedGraphDb() {
        return graphDb;
    }

    protected boolean restartGraphDbBetweenTests() {
        return false;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public static String getStorePath(String endPath) {
        return new File(NEO4J_BASE_DIR, endPath).getAbsolutePath();
    }

    @Before
    public void setUpTest() {
        if (this.restartGraphDbBetweenTests() && graphDb == null) {
            AbstractNeo4jTestCase.setupGraphDatabase(requiresPersistentGraphDatabase);
        }
        this.tx = graphDb.beginTx();
    }

    @After
    public void tearDownTest() {
        if (this.tx != null) {
            this.tx.finish();
        }
        if (this.restartGraphDbBetweenTests()) {
            AbstractNeo4jTestCase.tearDownDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownDb() {
        try {
            if (graphDb != null) {
                graphDb.shutdown();
            }
        }
        finally {
            graphDb = null;
        }
    }

    public void setTransaction(Transaction tx) {
        this.tx = tx;
    }

    public Transaction newTransaction() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.finish();
        }
        this.tx = graphDb.beginTx();
        return this.tx;
    }

    public void commit() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.finish();
            this.tx = null;
        }
    }

    public void rollback() {
        if (this.tx != null) {
            this.tx.failure();
            this.tx.finish();
            this.tx = null;
        }
    }

    public NodeManager getNodeManager() {
        return graphDb.getNodeManager();
    }

    public static void deleteFileOrDirectory(String dir) {
        AbstractNeo4jTestCase.deleteFileOrDirectory(new File(dir));
    }

    public static void deleteFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                AbstractNeo4jTestCase.deleteFileOrDirectory(child);
            }
        } else {
            file.delete();
        }
    }

    protected void clearCache() {
        this.getEmbeddedGraphDb().getNodeManager().clearCache();
    }

    protected long propertyRecordsInUse() {
        return this.propertyStore().getNumberOfIdsInUse();
    }

    protected long dynamicStringRecordsInUse() {
        return this.dynamicRecordsInUse("stringPropertyStore");
    }

    protected long dynamicArrayRecordsInUse() {
        return this.dynamicRecordsInUse("arrayPropertyStore");
    }

    private long dynamicRecordsInUse(String fieldName) {
        try {
            Field storeField = PropertyStore.class.getDeclaredField(fieldName);
            storeField.setAccessible(true);
            return ((AbstractDynamicStore)storeField.get(this.propertyStore())).getNumberOfIdsInUse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected PropertyStore propertyStore() {
        XaDataSourceManager dsMgr = graphDb.getXaDataSourceManager();
        return dsMgr.getNeoStoreDataSource().getXaConnection().getPropertyStore();
    }

    static {
        requiresPersistentGraphDatabase = false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface RequiresPersistentGraphDatabase {
        public boolean value() default true;
    }
}

