/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseConfigurationMigrator;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.StringLogger;

public class TestGraphDatabaseConfigurationMigrator {
    @Test
    public void testNoMigration() {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"foo", "bar"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"foo", "bar"})));
    }

    @Test
    public void testEnableOnlineBackup() {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"enable_online_backup", "true"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"online_backup_enabled", "true", "online_backup_port", "6362"})));
    }

    @Test
    public void testUdcEnabled() {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"neo4j.ext.udc.disable", "true"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"neo4j.ext.udc.enabled", "false"})));
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"neo4j.ext.udc.disable", "false"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"neo4j.ext.udc.enabled", "true"})));
    }

    @Test
    public void testEnableRemoteShell() {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"enable_remote_shell", "true"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"remote_shell_enabled", "true"})));
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"enable_remote_shell", "false"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"remote_shell_enabled", "false"})));
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"enable_remote_shell", "port=1234"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"remote_shell_enabled", "true", "remote_shell_port", "1234", "remote_shell_read_only", "false", "remote_shell_name", "shell"})));
    }
}

