/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.Default;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.Migrator;
import org.neo4j.kernel.configuration.BaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationMigrator;

public class TestConfig {
    @Test
    public void shouldApplyDefaults() {
        Config config = new Config(new HashMap(), new Class[]{MySettingsWithDefaults.class});
        Assert.assertThat((Object)config.get((GraphDatabaseSetting)MySettingsWithDefaults.hello), (Matcher)CoreMatchers.is((Object)"Hello, World!"));
    }

    @Test
    public void shouldApplyMigrations() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("old", "hello!");
        Config config = new Config(params, new Class[]{MyMigratingSettings.class});
        Assert.assertThat((Object)config.get((GraphDatabaseSetting)MyMigratingSettings.newer), (Matcher)CoreMatchers.is((Object)"hello!"));
    }

    @Test
    public void shouldNotAllowSettingInvalidValues() {
        Config config = new Config(new HashMap(), new Class[]{MySettingsWithDefaults.class});
        try {
            Map params = config.getParams();
            params.put(MySettingsWithDefaults.boolSetting.name(), "asd");
            config.applyChanges(params);
            Assert.fail((String)"Expected validation to fail.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowInvalidValuesInConstructor() {
        try {
            new Config((Map)new HashMap<String, String>(){
                {
                    this.put(MySettingsWithDefaults.boolSetting.name(), "asd");
                }
            }, new Class[]{MySettingsWithDefaults.class});
            Assert.fail((String)"Expected validation to fail.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static class MySettingsWithDefaults {
        @Default(value="Hello, World!")
        public static GraphDatabaseSetting.StringSetting hello = new GraphDatabaseSetting.StringSetting("hello", ".*", "");
        @Default(value="true")
        public static GraphDatabaseSetting.BooleanSetting boolSetting = new GraphDatabaseSetting.BooleanSetting("bool_setting");
    }

    public static class MyMigratingSettings {
        @Migrator
        public static ConfigurationMigrator migrator = new BaseConfigurationMigrator(){
            {
                this.add((BaseConfigurationMigrator.Migration)new BaseConfigurationMigrator.SpecificPropertyMigration("old", "Old has been replaced by newer!"){

                    public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                        rawConfiguration.put(newer.name(), value);
                    }
                });
            }
        };
        public static GraphDatabaseSetting.StringSetting newer = new GraphDatabaseSetting.StringSetting("hello", ".*", "");
    }
}

