/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.EmbeddedDatabaseRule;

public class TransactionLifecycleTest {
    @Rule
    public EmbeddedDatabaseRule database = new EmbeddedDatabaseRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=NotFoundException.class)
    public void givenACallToFailATransactionSubsequentSuccessCallsShouldBeSwallowedSilently() {
        GraphDatabaseService graphdb = this.database.getGraphDatabaseService();
        Transaction tx = graphdb.beginTx();
        Node someNode = null;
        try {
            someNode = graphdb.createNode();
            tx.failure();
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertNull((Object)graphdb.getNodeById(someNode.getId()));
    }
}

