/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public abstract class KernelExtensionContractTest<S, X extends KernelExtension<S>> {
    private final Class<X> extClass;
    private final String key;
    private final TargetDirectory target = TargetDirectory.forTest(this.getClass());

    public KernelExtensionContractTest(String key, Class<X> extClass) {
        this.extClass = extClass;
        this.key = key;
    }

    GraphDatabaseService graphdb(String name, boolean loadExtensions, int instance) {
        Map<String, String> config = this.configuration(true, instance);
        config.put(GraphDatabaseSettings.load_kernel_extensions.name(), Boolean.toString(loadExtensions));
        return new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.target.directory(name, true).getAbsolutePath()).setConfig(config).newGraphDatabase();
    }

    protected Map<String, String> configuration(boolean shouldLoad, int instance) {
        return MapUtil.stringMap((String[])new String[0]);
    }

    protected boolean isOkForDifferentKernels(S state1, S state2) {
        return state1 != state2;
    }

    protected boolean isUnloaded(S state) {
        return true;
    }

    protected boolean isLoadedOk(KernelData kernel) {
        return this.newInstance().isLoaded(kernel);
    }

    protected boolean isLoadedState(S state) {
        return state != null;
    }

    static KernelData getExtensions(GraphDatabaseService graphdb) {
        return ((GraphDatabaseAPI)graphdb).getKernelData();
    }

    @Test
    public void extensionShouldHavePublicNoArgConstructor() throws Exception {
        Object instance = null;
        try {
            instance = this.newInstance();
        }
        catch (IllegalArgumentException failure) {
            failure.printStackTrace();
            Assert.fail((String)"Contract violation: extension class must have public no-arg constructor (Exception in stderr)");
        }
        Assert.assertNotNull(instance);
    }

    @Test
    public void shouldBeAbleToLoadExtensionAsAServiceProvider() throws Exception {
        Object instance = null;
        try {
            instance = this.loadInstance();
        }
        catch (ClassCastException failure) {
            failure.printStackTrace();
            Assert.fail((String)"Loaded instance does not match the extension class (Exception in stderr)");
        }
        Assert.assertNotNull((String)"Could not load the kernel extension with the provided key", instance);
        Assert.assertTrue((String)"Class of the loaded instance is a subclass of the extension class", (instance.getClass() == this.extClass ? 1 : 0) != 0);
    }

    @Test
    public void differentInstancesShouldHaveEqualHashCodesAndBeEqual() throws Exception {
        X one = this.newInstance();
        X two = this.newInstance();
        Assert.assertEquals((String)"new instances have different hash codes", (long)one.hashCode(), (long)two.hashCode());
        Assert.assertEquals((String)"new instances are not equals", one, two);
        one = this.loadInstance();
        two = this.loadInstance();
        Assert.assertEquals((String)"loaded instances have different hash codes", (long)one.hashCode(), (long)two.hashCode());
        Assert.assertEquals((String)"loaded instances are not equals", one, two);
        one = this.loadInstance();
        two = this.newInstance();
        Assert.assertEquals((String)"loaded instance and new instance have different hash codes", (long)one.hashCode(), (long)two.hashCode());
        Assert.assertEquals((String)"loaded instance and new instance are not equals", one, two);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canLoadKernelExtension() throws Exception {
        GraphDatabaseService graphdb = this.graphdb("graphdb", true, 0);
        try {
            Assert.assertTrue((String)"Failed to load extension", (boolean)this.isLoadedOk(KernelExtensionContractTest.getExtensions(graphdb)));
        }
        finally {
            graphdb.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void differentInstancesUseSameState() throws Exception {
        GraphDatabaseService graphdb = this.graphdb("graphdb", true, 0);
        try {
            KernelData kernel = KernelExtensionContractTest.getExtensions(graphdb);
            Assert.assertSame((Object)this.newInstance().getState(kernel), (Object)this.newInstance().getState(kernel));
        }
        finally {
            graphdb.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sameInstanceCanLoadWithMultipleKernels() throws Exception {
        GraphDatabaseService graphdb1 = this.graphdb("graphdb1", false, 1);
        try {
            GraphDatabaseService graphdb2 = this.graphdb("graphdb2", false, 2);
            try {
                KernelData extensions1 = KernelExtensionContractTest.getExtensions(graphdb1);
                KernelData extensions2 = KernelExtensionContractTest.getExtensions(graphdb2);
                X instance = this.newInstance();
                extensions1.loadExtensions(Collections.singleton(instance), StringLogger.SYSTEM);
                extensions2.loadExtensions(Collections.singleton(instance), StringLogger.SYSTEM);
                Object state1 = extensions1.getState(this.newInstance());
                Object state2 = extensions2.getState(this.newInstance());
                Assert.assertTrue((String)"Failed to load extension with first kernel", (boolean)this.isLoadedState(state1));
                Assert.assertTrue((String)"Failed to load extension with second kernel", (boolean)this.isLoadedState(state2));
                Assert.assertTrue((String)"Loaded same extension state for both kernels", (boolean)this.isOkForDifferentKernels(state1, state2));
                this.testUnload("first kernel", extensions1, instance, state1);
                this.testUnload("second kernel", extensions2, instance, state2);
            }
            finally {
                graphdb2.shutdown();
            }
        }
        finally {
            graphdb1.shutdown();
        }
    }

    private void testUnload(String kernelName, KernelData kernel, X instance, S state) {
        kernel.shutdown(StringLogger.SYSTEM);
        Assert.assertTrue((String)("Internal failure: failed to unload extension with " + kernelName), (kernel.getState(instance) == null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Failed to unload instance with " + kernelName), (boolean)this.isUnloaded(state));
    }

    private final X newInstance() {
        try {
            return (X)((KernelExtension)this.extClass.newInstance());
        }
        catch (Exception cause) {
            throw new IllegalArgumentException("Could not instantiate extension class", cause);
        }
    }

    protected final X loadInstance() {
        return (X)((KernelExtension)this.extClass.cast(Service.load(KernelExtension.class, (String)this.key)));
    }
}

