/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.InternalAbstractGraphDatabase;

public class GuardPerformanceImpact {
    private static final int RUNS = 10;
    private static final int PER_TX = 10000;
    private static final int TX = 100;

    public static void main(String[] args) throws IOException {
        GuardPerformanceImpact.test(Type.enabled);
    }

    private static void test(Type type) throws IOException {
        switch (type) {
            case without: {
                for (int i = 0; i < 10; ++i) {
                    System.err.println(GuardPerformanceImpact.withoutGuard());
                }
                break;
            }
            case enabled: {
                for (int i = 0; i < 10; ++i) {
                    System.err.println(GuardPerformanceImpact.guardEnabled());
                }
                break;
            }
            case activeOpscount: {
                for (int i = 0; i < 10; ++i) {
                    System.err.println(GuardPerformanceImpact.guardEnabledAndActiveOpsCount());
                }
                break;
            }
            case activeTimeout: {
                for (int i = 0; i < 10; ++i) {
                    System.err.println(GuardPerformanceImpact.guardEnabledAndActiveTimeout());
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long withoutGuard() throws IOException {
        InternalAbstractGraphDatabase db = GuardPerformanceImpact.prepare(false);
        try {
            long start = System.currentTimeMillis();
            GuardPerformanceImpact.createData(db);
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            GuardPerformanceImpact.cleanup(db);
        }
    }

    private static InternalAbstractGraphDatabase prepare(boolean insertGuard) throws IOException {
        File tmpFile = File.createTempFile("neo4j-test", "");
        tmpFile.delete();
        return new EmbeddedGraphDatabase(tmpFile.getCanonicalPath(), MapUtil.stringMap((String[])new String[]{"enable_execution_guard", String.valueOf(insertGuard)}));
    }

    private static void createData(InternalAbstractGraphDatabase db) {
        for (int j = 0; j < 100; ++j) {
            Transaction tx = db.beginTx();
            for (int i = 0; i < 10000; ++i) {
                db.createNode();
            }
            tx.success();
            tx.finish();
        }
    }

    private static void cleanup(InternalAbstractGraphDatabase db) {
        db.shutdown();
        GuardPerformanceImpact.deleteFiles(new File(db.getStoreDir()));
    }

    private static void deleteFiles(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                GuardPerformanceImpact.deleteFiles(file);
            }
        }
        directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long guardEnabled() throws IOException {
        InternalAbstractGraphDatabase db = GuardPerformanceImpact.prepare(true);
        try {
            long start = System.currentTimeMillis();
            GuardPerformanceImpact.createData(db);
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            GuardPerformanceImpact.cleanup(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long guardEnabledAndActiveOpsCount() throws IOException {
        InternalAbstractGraphDatabase db = GuardPerformanceImpact.prepare(true);
        try {
            long start = System.currentTimeMillis();
            db.getGuard().startOperationsCount(Integer.MAX_VALUE);
            GuardPerformanceImpact.createData(db);
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            GuardPerformanceImpact.cleanup(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long guardEnabledAndActiveTimeout() throws IOException {
        InternalAbstractGraphDatabase db = GuardPerformanceImpact.prepare(true);
        try {
            long start = System.currentTimeMillis();
            db.getGuard().startTimeout(Integer.MAX_VALUE);
            GuardPerformanceImpact.createData(db);
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            GuardPerformanceImpact.cleanup(db);
        }
    }

    private static enum Type {
        without,
        enabled,
        activeTimeout,
        activeOpscount;

    }
}

