/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.configuration.Config;

public class TestGraphDatabaseSetting {
    @Test
    public void testStringSetting() {
        GraphDatabaseSetting.StringSetting stringSetting = new GraphDatabaseSetting.StringSetting("foo_bar", ".+", "Must be a valid foo bar");
        Assert.assertThat((Object)stringSetting.name(), (Matcher)CoreMatchers.equalTo((Object)"foo_bar"));
        stringSetting.validate("test");
        try {
            stringSetting.validate(null);
            Assert.fail((String)"null should not be allowed");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            stringSetting.validate("");
            Assert.fail((String)"empty string should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIntegerSetting() {
        GraphDatabaseSetting.IntegerSetting integerSetting = new GraphDatabaseSetting.IntegerSetting("foo_bar", "Must be a valid integer", Integer.valueOf(3), Integer.valueOf(10));
        Assert.assertThat((Object)integerSetting.name(), (Matcher)CoreMatchers.equalTo((Object)"foo_bar"));
        integerSetting.validate("5");
        integerSetting.validate("3");
        integerSetting.validate("10");
        try {
            integerSetting.validate("2");
            Assert.fail((String)"too low number should not be allowed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Invalid value '2' for config property 'foo_bar': Minimum allowed value is: 3"));
        }
        try {
            integerSetting.validate("11");
            Assert.fail((String)"too high number should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOptionsSetting() {
        GraphDatabaseSetting.OptionsSetting optionsSetting = new GraphDatabaseSetting.OptionsSetting("foo_bar", new String[]{"option1", "option2", "option3"});
        Assert.assertThat((Object)optionsSetting.name(), (Matcher)CoreMatchers.equalTo((Object)"foo_bar"));
        optionsSetting.validate("option1");
        optionsSetting.validate("option2");
        try {
            optionsSetting.validate("option4");
            Assert.fail((String)"invalid option should not be allowed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Invalid value 'option4' for config property 'foo_bar': Invalid option. Valid options are:[option1, option2, option3]"));
        }
    }

    @Test
    public void testFileSetting() {
        GraphDatabaseSetting.FileSetting fileSetting = new GraphDatabaseSetting.FileSetting("myfile");
        Assert.assertThat((Object)fileSetting.name(), (Matcher)CoreMatchers.equalTo((Object)"myfile"));
        fileSetting.validate("/some/path");
        try {
            fileSetting.validate(null);
            Assert.fail((String)"null paths should not be allowed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Invalid value [null] for config property 'myfile': Must be a valid file path."));
        }
    }

    @Test
    public void testRelativeFileSetting() throws IOException {
        GraphDatabaseSetting.DirectorySetting baseDir = new GraphDatabaseSetting.DirectorySetting("myDirectory");
        GraphDatabaseSetting.FileSetting fileSetting = new GraphDatabaseSetting.FileSetting("myfile", baseDir, true, true);
        Config config = new Config((Map)new HashMap<String, String>(){
            {
                this.put("myDirectory", "/home/jake");
            }
        });
        Assert.assertThat((Object)fileSetting.valueOf("baa", config), (Matcher)CoreMatchers.equalTo((Object)new File("/home/jake/baa").getCanonicalPath()));
        if (GraphDatabaseSetting.osIsWindows()) {
            Assert.assertThat((Object)fileSetting.valueOf("c:\\baa", config), (Matcher)CoreMatchers.equalTo((Object)new File("c:\\baa").getCanonicalPath()));
        } else {
            Assert.assertThat((Object)fileSetting.valueOf("/baa", config), (Matcher)CoreMatchers.equalTo((Object)new File("/baa").getAbsolutePath()));
            Assert.assertThat((Object)fileSetting.valueOf("\\baa\\boo", config), (Matcher)CoreMatchers.equalTo((Object)new File("/baa/boo").getCanonicalPath()));
        }
    }

    @Test
    public void testURISetting() {
        GraphDatabaseSetting.URISetting setting = new GraphDatabaseSetting.URISetting("myfile", true);
        Config config = (Config)Mockito.mock(Config.class);
        Assert.assertThat((Object)setting.valueOf("/baa/boo", config).toString(), (Matcher)CoreMatchers.equalTo((Object)"/baa/boo"));
        Assert.assertThat((Object)setting.valueOf("/baa/", config).toString(), (Matcher)CoreMatchers.equalTo((Object)"/baa"));
    }

    @Test
    public void testNumberOfBytesSetting() {
        GraphDatabaseSetting.NumberOfBytesSetting setting = new GraphDatabaseSetting.NumberOfBytesSetting("mysize");
        Config config = (Config)Mockito.mock(Config.class);
        this.assertValidationPasses((GraphDatabaseSetting<?>)setting, "1");
        this.assertValidationPasses((GraphDatabaseSetting<?>)setting, "23");
        this.assertValidationPasses((GraphDatabaseSetting<?>)setting, "12G");
        this.assertValidationPasses((GraphDatabaseSetting<?>)setting, "12 g");
        this.assertValidationPasses((GraphDatabaseSetting<?>)setting, "12 G");
        this.assertValidationFails((GraphDatabaseSetting<?>)setting, null);
        this.assertValidationFails((GraphDatabaseSetting<?>)setting, "");
        this.assertValidationFails((GraphDatabaseSetting<?>)setting, "asd");
        Assert.assertThat((Object)setting.valueOf("12", config), (Matcher)CoreMatchers.equalTo((Object)12L));
        Assert.assertThat((Object)setting.valueOf("12k", config), (Matcher)CoreMatchers.equalTo((Object)12288L));
        Assert.assertThat((Object)setting.valueOf("12m", config), (Matcher)CoreMatchers.equalTo((Object)0xC00000L));
        Assert.assertThat((Object)setting.valueOf("12g", config), (Matcher)CoreMatchers.equalTo((Object)0x300000000L));
        Assert.assertThat((Object)setting.valueOf("12 g", config), (Matcher)CoreMatchers.equalTo((Object)0x300000000L));
    }

    private void assertValidationPasses(GraphDatabaseSetting<?> setting, String value) {
        setting.validate(value);
    }

    private void assertValidationFails(GraphDatabaseSetting<?> setting, String value) {
        try {
            setting.validate(value);
            Assert.fail((String)("Expected validation of value " + (value == null ? "[null]" : "'" + value + "'") + " to fail."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

