/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.cache.SoftCacheProvider;

public class SetCacheProvidersTest {
    @Test
    public void testSetNoCache() {
        ArrayList cacheList = new ArrayList();
        GraphDatabaseFactory gdbf = new GraphDatabaseFactory();
        gdbf.setCacheProviders(cacheList);
        try {
            gdbf.newEmbeddedDatabase("target/db");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().contains("No cache type"));
        }
    }

    @Test
    public void testSetSoftRefCache() {
        ArrayList<SoftCacheProvider> cacheList = new ArrayList<SoftCacheProvider>();
        GraphDatabaseFactory gdbf = new GraphDatabaseFactory();
        cacheList.add(new SoftCacheProvider());
        gdbf.setCacheProviders(cacheList);
        EmbeddedGraphDatabase db = (EmbeddedGraphDatabase)gdbf.newEmbeddedDatabase("target/db");
        Assert.assertEquals((Object)"soft", (Object)db.getNodeManager().getCacheType().getName());
    }
}

