/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInsertExampleTest {
    @Test
    public void insert() throws IOException {
        FileUtils.deleteRecursively((File)new File("target/batchinserter-example"));
        BatchInserter inserter = BatchInserters.inserter((String)"target/batchinserter-example");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", "Mattias");
        long mattiasNode = inserter.createNode(properties);
        properties.put("name", "Chris");
        long chrisNode = inserter.createNode(properties);
        DynamicRelationshipType knows = DynamicRelationshipType.withName((String)"KNOWS");
        inserter.createRelationship(mattiasNode, chrisNode, (RelationshipType)knows, null);
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase("target/batchinserter-example");
        Node mNode = db.getNodeById(mattiasNode);
        Node cNode = mNode.getSingleRelationship((RelationshipType)knows, Direction.OUTGOING).getEndNode();
        Assert.assertEquals((Object)"Chris", (Object)cNode.getProperty("name"));
        db.shutdown();
    }

    @Test
    public void insertWithConfig() throws IOException {
        FileUtils.deleteRecursively((File)new File("target/batchinserter-example-config"));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("neostore.nodestore.db.mapped_memory", "90M");
        BatchInserter inserter = BatchInserters.inserter((String)"target/batchinserter-example-config", config);
        inserter.shutdown();
    }

    @Test
    public void insertWithConfigFile() throws IOException {
        FileUtils.deleteRecursively((File)new File("target/batchinserter-example-config"));
        FileWriter fw = new FileWriter("target/batchinsert-config");
        fw.append("neostore.nodestore.db.mapped_memory=90M\nneostore.relationshipstore.db.mapped_memory=3G\nneostore.propertystore.db.mapped_memory=50M\nneostore.propertystore.db.strings.mapped_memory=100M\nneostore.propertystore.db.arrays.mapped_memory=0M");
        fw.close();
        Map config = MapUtil.load((File)new File("target/batchinsert-config"));
        BatchInserter inserter = BatchInserters.inserter((String)"target/batchinserter-example-config", (Map)config);
        inserter.shutdown();
    }

    @Test
    public void batchDb() throws IOException {
        FileUtils.deleteRecursively((File)new File("target/batchdb-example"));
        GraphDatabaseService batchDb = BatchInserters.batchDatabase((String)"target/batchdb-example");
        Node mattiasNode = batchDb.createNode();
        mattiasNode.setProperty("name", (Object)"Mattias");
        Node chrisNode = batchDb.createNode();
        chrisNode.setProperty("name", (Object)"Chris");
        DynamicRelationshipType knows = DynamicRelationshipType.withName((String)"KNOWS");
        mattiasNode.createRelationshipTo(chrisNode, (RelationshipType)knows);
        long mattiasNodeId = mattiasNode.getId();
        batchDb.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase("target/batchdb-example");
        Node mNode = db.getNodeById(mattiasNodeId);
        Node cNode = mNode.getSingleRelationship((RelationshipType)knows, Direction.OUTGOING).getEndNode();
        Assert.assertEquals((Object)"Chris", (Object)cNode.getProperty("name"));
        db.shutdown();
    }

    @Test
    public void batchDbWithConfig() throws IOException {
        FileUtils.deleteRecursively((File)new File("target/batchdb-example-config"));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("neostore.nodestore.db.mapped_memory", "90M");
        GraphDatabaseService batchDb = BatchInserters.batchDatabase((String)"target/batchdb-example-config", config);
        batchDb.shutdown();
    }
}

