/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;

public class KernelBean
extends Neo4jMBean
implements Kernel {
    private final long kernelStartTime;
    private final long storeCreationDate;
    private final long storeId;
    private final long storeLogVersion;
    private final boolean isReadOnly;
    private final String kernelVersion;
    private final String storeDir;
    private final ObjectName query;
    private final String instanceId;

    KernelBean(KernelData kernel, ManagementSupport support) throws NotCompliantMBeanException {
        super(Kernel.class, kernel, support);
        String storeDir;
        NeoStoreXaDataSource datasource = KernelBean.getNeoDataSource(kernel);
        this.kernelVersion = kernel.version().toString();
        this.instanceId = kernel.instanceId();
        this.query = support.createMBeanQuery(this.instanceId);
        this.storeCreationDate = datasource.getCreationTime();
        this.storeLogVersion = datasource.getCurrentLogVersion();
        this.isReadOnly = datasource.isReadOnly();
        this.storeId = datasource.getRandomIdentifier();
        try {
            storeDir = new File(datasource.getStoreDir()).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            storeDir = new File(datasource.getStoreDir()).getAbsolutePath();
        }
        this.storeDir = storeDir;
        this.kernelStartTime = new Date().getTime();
    }

    String getInstanceId() {
        return this.instanceId;
    }

    public static NeoStoreXaDataSource getNeoDataSource(KernelData kernel) {
        XaDataSourceManager mgr = kernel.graphDatabase().getXaDataSourceManager();
        return mgr.getNeoStoreDataSource();
    }

    @Override
    public ObjectName getMBeanQuery() {
        return this.query;
    }

    @Override
    public Date getKernelStartTime() {
        return new Date(this.kernelStartTime);
    }

    @Override
    public Date getStoreCreationDate() {
        return new Date(this.storeCreationDate);
    }

    @Override
    public String getStoreId() {
        return Long.toHexString(this.storeId);
    }

    @Override
    public long getStoreLogVersion() {
        return this.storeLogVersion;
    }

    @Override
    public String getKernelVersion() {
        return this.kernelVersion;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public String getStoreDirectory() {
        return this.storeDir;
    }
}

