/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.neo4j.jmx.Description;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.impl.annotations.Documented;

@Description(value="The configuration parameters used to configure Neo4j")
public final class ConfigurationBean
extends Neo4jMBean {
    public static final String CONFIGURATION_MBEAN_NAME = "Configuration";
    private final Map<String, String> config;
    private static final Map<String, String> parameterDescriptions;

    ConfigurationBean(KernelData kernel, ManagementSupport support) throws NotCompliantMBeanException {
        super(CONFIGURATION_MBEAN_NAME, kernel, support);
        this.config = kernel.getConfigParams();
    }

    private static String describeConfigParameter(String param) {
        String description = parameterDescriptions.get(param);
        return description != null ? description : "Configuration attribute";
    }

    private MBeanAttributeInfo[] keys() {
        ArrayList<MBeanAttributeInfo> keys = new ArrayList<MBeanAttributeInfo>();
        for (Map.Entry<String, String> entry : this.config.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            keys.add(new MBeanAttributeInfo(entry.getKey(), String.class.getName(), ConfigurationBean.describeConfigParameter(entry.getKey()), true, false, false));
        }
        return keys.toArray(new MBeanAttributeInfo[keys.size()]);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.config.get(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList(attributes.length);
        for (String attribute : attributes) {
            try {
                result.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Description description = this.getClass().getAnnotation(Description.class);
        return new MBeanInfo(this.getClass().getName(), description != null ? description.value() : "Neo4j configuration", this.keys(), null, null, null);
    }

    static {
        HashMap<String, String> descriptions = new HashMap<String, String>();
        for (Field field : Config.class.getFields()) {
            Documented documentation;
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || (documentation = field.getAnnotation(Documented.class)) == null || field.getType() != String.class) continue;
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                descriptions.put((String)field.get(null), documentation.value());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        parameterDescriptions = Collections.unmodifiableMap(descriptions);
    }
}

