/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.codegen;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;

public class ResultRowImpl
implements Result.ResultRow {
    private Map<String, Object> results = new HashMap<String, Object>();

    public void set(String k, Object value) {
        this.results.put(k, value);
    }

    public Object get(String key) {
        return this.get(key, Object.class);
    }

    public Node getNode(String key) {
        return this.get(key, Node.class);
    }

    public Relationship getRelationship(String key) {
        return this.get(key, Relationship.class);
    }

    public String getString(String key) {
        return this.get(key, String.class);
    }

    public Number getNumber(String key) {
        return this.get(key, Number.class);
    }

    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    public Path getPath(String key) {
        return this.get(key, Path.class);
    }

    private <T> T get(String key, Class<T> type) {
        Object value = this.results.get(key);
        if (value == null && !this.results.containsKey(key)) {
            throw new IllegalArgumentException("No column \"" + key + "\" exists");
        }
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            String message = String.format("The current item in column \"%s\" is not a %s; it's \"%s\"", key, type.getSimpleName(), value);
            throw new NoSuchElementException(message);
        }
    }
}

