/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

public class Numbers {
    public static short safeCastIntToUnsignedShort(int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw new ArithmeticException(Numbers.getOverflowMessage((long)value, "unsigned short"));
        }
        return (short)value;
    }

    public static int safeCastLongToInt(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException(Numbers.getOverflowMessage(value, Integer.TYPE));
        }
        return (int)value;
    }

    public static short safeCastLongToShort(long value) {
        if ((long)((short)value) != value) {
            throw new ArithmeticException(Numbers.getOverflowMessage(value, Short.TYPE));
        }
        return (short)value;
    }

    public static short safeCastIntToShort(int value) {
        if ((short)value != value) {
            throw new ArithmeticException(Numbers.getOverflowMessage((long)value, Short.TYPE));
        }
        return (short)value;
    }

    public static byte safeCastLongToByte(long value) {
        if ((long)((byte)value) != value) {
            throw new ArithmeticException(Numbers.getOverflowMessage(value, Byte.TYPE));
        }
        return (byte)value;
    }

    public static int unsignedShortToInt(short value) {
        return value & 0xFFFF;
    }

    private static String getOverflowMessage(long value, Class clazz) {
        return Numbers.getOverflowMessage(value, clazz.getName());
    }

    private static String getOverflowMessage(long value, String numericType) {
        return "Value " + value + " is too big to be represented as " + numericType;
    }
}

