/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.server.rest.security.SecurityRule;
import org.neo4j.server.rest.security.UriPathWildcardMatcher;

public class SecurityFilter
implements Filter {
    private final SecurityRule rule;
    private final UriPathWildcardMatcher pathMatcher;

    public SecurityFilter(SecurityRule rule) {
        this.rule = rule;
        String rulePath = rule.forUriPath();
        if (!rulePath.endsWith("*")) {
            rulePath = rulePath + "*";
        }
        this.pathMatcher = new UriPathWildcardMatcher(rulePath);
    }

    public SecurityRule getRule() {
        return this.rule;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.validateRequestType(request);
        this.validateResponseType(response);
        HttpServletRequest httpReq = (HttpServletRequest)request;
        String path = httpReq.getContextPath() + (httpReq.getPathInfo() == null ? "" : httpReq.getPathInfo());
        this.pathMatcher.matches(path);
        if (!this.pathMatcher.matches(path) || this.rule.isAuthorized(httpReq)) {
            chain.doFilter(request, response);
        } else {
            this.createUnauthorizedChallenge(response);
        }
    }

    private void validateRequestType(ServletRequest request) throws ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException(String.format("Expected HttpServletRequest, received [%s]", request.getClass().getCanonicalName()));
        }
    }

    private void validateResponseType(ServletResponse response) throws ServletException {
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException(String.format("Expected HttpServletResponse, received [%s]", response.getClass().getCanonicalName()));
        }
    }

    private void createUnauthorizedChallenge(ServletResponse response) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setStatus(401);
        httpServletResponse.addHeader("WWW-Authenticate", this.rule.wwwAuthenticateHeader());
    }

    public void destroy() {
    }

    public static String basicAuthenticationResponse(String realm) {
        return "Basic realm=\"" + realm + "\"";
    }
}

