/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.impl;

import lombok.NonNull;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaDeallocator
implements Deallocator {
    private static final Logger log = LoggerFactory.getLogger(CudaDeallocator.class);
    private OpaqueDataBuffer opaqueDataBuffer;

    public CudaDeallocator(@NonNull BaseCudaDataBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.opaqueDataBuffer = buffer.getOpaqueDataBuffer();
    }

    public void deallocate() {
        log.trace("Deallocating CUDA memory");
        NativeOpsHolder.getInstance().getDeviceNativeOps().deleteDataBuffer(this.opaqueDataBuffer);
    }
}

