/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;

public class BernoulliDistribution
extends BaseRandomOp {
    private double prob;

    public BernoulliDistribution(SameDiff sd, double prob, long[] shape) {
        super(sd, shape);
        this.prob = prob;
        this.extraArgs = new Object[]{this.prob};
    }

    public BernoulliDistribution(SameDiff sd, double prob, DataType dataType, long[] shape) {
        this(sd, prob, shape);
        this.prob = prob;
        this.extraArgs = new Object[]{this.prob};
        this.dataType = dataType;
    }

    public BernoulliDistribution() {
    }

    public BernoulliDistribution(double p, DataType datatype, long ... shape) {
        this(Nd4j.createUninitialized(datatype, shape), p);
    }

    public BernoulliDistribution(@NonNull INDArray z, double prob) {
        super(null, null, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        this.prob = prob;
        this.extraArgs = new Object[]{this.prob};
    }

    public BernoulliDistribution(@NonNull INDArray z, @NonNull INDArray prob) {
        super(prob, null, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        if (prob == null) {
            throw new NullPointerException("prob is marked non-null but is null");
        }
        if (prob.elementWiseStride() != 1) {
            throw new ND4JIllegalStateException("Probabilities should have ElementWiseStride of 1");
        }
        if (prob.length() != z.length()) {
            throw new ND4JIllegalStateException("Length of probabilities array [" + prob.length() + "] doesn't match length of output array [" + z.length() + "]");
        }
        this.prob = 0.0;
        this.extraArgs = new Object[]{this.prob};
    }

    @Override
    public int opNum() {
        return 7;
    }

    @Override
    public String opName() {
        return "distribution_bernoulli";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        return this.calculateOutputShape();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        LongShapeDescriptor longShapeDescriptor = LongShapeDescriptor.fromShape(this.shape, this.dataType);
        return Arrays.asList(longShapeDescriptor);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes == null || inputDataTypes.isEmpty() ? 1 : 0) != 0, (String)"Expected no input datatypes (no args) for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(this.dataType);
    }
}

