/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce.custom;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public abstract class BaseDynamicCustomReduction
extends DynamicCustomOp {
    protected boolean keepDims = false;
    protected boolean isComplex = false;
    protected boolean isEmptyReduce = false;
    protected int[] dimensions;

    public BaseDynamicCustomReduction() {
    }

    public BaseDynamicCustomReduction(SameDiff sameDiff, SDVariable[] args, boolean keepDims) {
        this(sameDiff, args, keepDims, false);
    }

    public BaseDynamicCustomReduction(SameDiff sameDiff, SDVariable[] args, boolean keepDims, int[] dimensions) {
        this(sameDiff, args, keepDims, false, dimensions);
    }

    public BaseDynamicCustomReduction(SameDiff sameDiff, SDVariable[] args, boolean keepDims, boolean isComplex) {
        super(null, sameDiff, args);
        this.isComplex = isComplex;
        this.keepDims = keepDims;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(SameDiff sameDiff, SDVariable[] args, boolean keepDims, boolean isComplex, int[] dimensions) {
        super(null, sameDiff, args);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(INDArray[] inputs, INDArray[] outputs) {
        super(null, inputs, outputs);
    }

    public BaseDynamicCustomReduction(INDArray[] inputs, INDArray[] outputs, boolean keepDims) {
        this(inputs, outputs, keepDims, null);
    }

    public BaseDynamicCustomReduction(INDArray[] inputs, INDArray[] outputs, boolean keepDims, int[] dimensions) {
        this(inputs, outputs);
        this.keepDims = keepDims;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(INDArray[] inputs, boolean keepDims, int[] dimensions) {
        this(inputs, null, keepDims, dimensions);
    }

    public BaseDynamicCustomReduction(boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(SameDiff sameDiff, SDVariable arg, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(sameDiff, arg);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(SameDiff sameDiff, SDVariable[] args, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(sameDiff, args);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(String opName, SameDiff sameDiff, SDVariable[] args, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(opName, sameDiff, args);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(String opName, INDArray input, INDArray output, List<Double> tArguments, int[] iArguments, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(opName, input, output, tArguments, iArguments);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(String opName, INDArray[] inputs, INDArray[] outputs, List<Double> tArguments, int[] iArguments, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(opName, inputs, outputs, tArguments, iArguments);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(String opName, INDArray[] inputs, INDArray[] outputs, List<Double> tArguments, List<Integer> iArguments, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(opName, inputs, outputs, tArguments, iArguments);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(INDArray[] inputs, INDArray[] outputs, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(inputs, outputs);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(String opName, INDArray[] inputs, INDArray[] outputs, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(opName, inputs, outputs);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(String opName, SameDiff sameDiff, SDVariable[] args, boolean inPlace, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(opName, sameDiff, args, inPlace);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(SameDiff sameDiff, SDVariable[] args, boolean inPlace, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(sameDiff, args, inPlace);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(String opName, boolean keepDims, boolean isComplex, boolean isEmptyReduce, int[] dimensions) {
        super(opName);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.isEmptyReduce = isEmptyReduce;
        this.dimensions = dimensions;
        this.addArgs();
    }

    public BaseDynamicCustomReduction(INDArray[] input, INDArray[] output, boolean keepDims, boolean isComplex, int[] dimensions) {
        super(null, input, output);
        this.keepDims = keepDims;
        this.isComplex = isComplex;
        this.dimensions = dimensions;
        this.addArgs();
    }

    protected void addArgs() {
        this.addBArgument(this.keepDims);
        if (this.dimensions != null) {
            for (int i = 0; i < this.dimensions.length; ++i) {
                this.addIArgument(this.dimensions[i]);
            }
        }
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        if (!this.dArguments.isEmpty()) {
            return Arrays.asList((DataType)((Object)this.dArguments.get(0)));
        }
        return Arrays.asList(dataTypes.get(0));
    }

    @Override
    public abstract String opName();

    public void setKeepDims(boolean keepDims) {
        this.keepDims = keepDims;
    }

    public boolean isKeepDims() {
        return this.keepDims;
    }

    public void setEmptyReduce(boolean isEmptyReduce) {
        this.isEmptyReduce = isEmptyReduce;
    }

    public boolean isEmptyReduce() {
        return this.isEmptyReduce;
    }
}

